<?php
/**
 * Tweaker5 functions and definitions
 *
 * @package tweaker5
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if ( ! isset( $content_width ) ) { 
	$content_width = 1024; 
}

if ( ! function_exists( 'tweaker5_setup' ) ) :
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
function tweaker5_setup() {

	/*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on tweaker5, use a find and replace
	 * to change 'tweaker5' to the name of your theme in all the template files
	 */
	load_theme_textdomain( 'tweaker5', get_template_directory() . '/languages' );

	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );

	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
	add_theme_support( 'post-thumbnails' );

	// This theme uses wp_nav_menu() in one location.
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'tweaker5' ),
		'top' => __( 'Top Menu', 'tweaker5' ),
		'social' => __( 'Social Menu', 'tweaker5' ),
		
	) );

	// Enable support for Post Formats.
	add_theme_support( 'post-formats', array( 'aside', 'audio', 'gallery', 'image', 'quote', 'video' ) );

	// Setup the WordPress core custom background feature.
	add_theme_support( 'custom-background', apply_filters( 'tweaker5_custom_background_args', array(
		'default-color' => 'ffffff',
		'default-image' => '',
	) ) );

	// Enable support for HTML5 markup.
	add_theme_support( 'html5', array( 'comment-list', 'search-form', 'comment-form', ) );
	
   // Add theme support for the JetPack infinity scroll.
    add_theme_support( 'infinite-scroll', array(
      	'posts_per_page' => 20,
   		'container'      => 'post',
      	'footer_widgets' => array( 'footer-sidebar-1', 'footer-sidebar-2', 'footer-sidebar-3', ),
      	'footer'         => 'page',
    ) );
	//Add theme support for the JetPack featured ontent.
	add_theme_support( 'featured-content', array(
    'filter'     => 'tweaker5_get_featured_content',
    'max_posts'  => 4,
) );
	
}
endif; // tweaker5_setup
add_action( 'after_setup_theme', 'tweaker5_setup' );

/**
 * Register widgetized area and update sidebar with default widgets.
 */
 add_action( 'widgets_init', 'tweaker5_widgets_init' );
 
function tweaker5_widgets_init() {
	register_sidebar( array(
		'name'          => __( 'Page Sidebar', 'tweaker5' ),
		'id'            => 'page-sidebar',
		'description'   => __( 'Widget(s) you place here will appear in the sidebar of the pages only.', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="sidebar-widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar( array(
		'name'          => __( 'Blog Sidebar', 'tweaker5' ),
		'id'            => 'blog-sidebar',
		'description'   => __( 'Widget(s) you place here will appear in the sidebar of all the blog and archive pages.', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="sidebar-widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar( array(
		'name'          => __( 'Single Page Sidebar', 'tweaker5' ),
		'id'            => 'single-sidebar',
		'description'   => __( 'Widget(s) you place here will appear in the sidebar of the single pages.', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="sidebar-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="sidebar-widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Sidebar 1', 'tweaker5' ),
		'id'            => 'footer-sidebar-1',
		'description'   => __( 'You can add widget(s) in up to 3 widget areas just above the footer. (See inc/footer-widgets.php for more details).', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer-widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Sidebar 2', 'tweaker5' ),
		'id'            => 'footer-sidebar-2',
		'description'   => __( 'You can add widget(s) in up to 3 widget areas just above the footer. (See inc/footer-widgets.php for more details).', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer-widget-title">',
		'after_title'   => '</h1>',
	) );
	register_sidebar( array(
		'name'          => __( 'Footer Sidebar 3', 'tweaker5' ),
		'id'            => 'footer-sidebar-3',
		'description'   => __( 'You can add widget(s) in up to 3 widget areas just above the footer. (See inc/footer-widgets.php for more details).', 'tweaker5' ),
		'before_widget' => '<section id="%1$s" class="footer-widget %2$s">',
		'after_widget'  => '</section>',
		'before_title'  => '<h1 class="footer-widget-title">',
		'after_title'   => '</h1>',
	) );
}
// Enqueue scripts and styles.
function tweaker5_scripts() {
	wp_enqueue_style( 'tweaker5-reset', get_template_directory_uri() . '/css/reset.css' );
	wp_enqueue_style( 'tweaker5-grid', get_template_directory_uri() . '/css/grid.css' );
	wp_enqueue_style( 'tweaker5-genericons', get_template_directory_uri().'/css/genericons/genericons.css' );
	wp_enqueue_style( 'tweaker5-style', get_stylesheet_uri() );
	wp_enqueue_script( 'tweaker5-skip-link-focus-fix', get_template_directory_uri() . '/js/skip-link-focus-fix.js', array(), '20130115', true );
	wp_enqueue_script( 'tweaker5-navigation', get_template_directory_uri() . '/js/navigation.js', array(), '20120206', true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'tweaker5_scripts' );

// Load custom editor styles
function tweaker5_add_editor_styles() {
    add_editor_style( get_template_directory_uri() . '/css/custom-edit-style.css' );
}
/**
 * Implement the Custom Header feature.
 * All relevant fustions to implement the custom header inluded here.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 * The paging_nav, post_nav and comments untions included here.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 * Includes the ilter for wp_title as well as the paginate,
 * first_image and copyright_notice functions.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 * All the necessary stuff for the settings etc. as used by the options setup in the customizer.
 * Sanitization functions used included here as well.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 * In here the stylesheet for the JetPak ontact form is de-registered.
 * This allows the plugin to use the theme's stylesheet.
 */
require get_template_directory() . '/inc/jetpack.php';
/* Load media file to fetch first video or audio from posts */
require get_template_directory() . '/inc/media.php';
/**
 * I remove the title attributes from the category widget.
 * WordPress uses the category description for these and this can be lengthy. 
 * If you want to restore these titles remove the following function:
 */
 
 /* Remove title attributes from category lists */
function tweaker5_list_categories_remove_title_attributes($output) {
	$output = preg_replace('` title="(.+)"`', '', $output);
	return $output;
}
add_filter('wp_list_categories', 'tweaker5_list_categories_remove_title_attributes');
/**
 * Function for featured content 
 */
function tweaker5_get_featured_content() {
    return apply_filters( 'tweaker5_get_featured_content', array() );
}