<?php
/**
 * The template part for displaying a message that posts cannot be found.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package tweaker5
 */
?>

<section class="no-results not-found">
	
    <header class="content-header">
		<h1 class="h3-size "><?php _e( 'No Posts As Yet', 'tweaker5' ); ?></h1>
	</header><?php // close .content-header ?>

	<div class="content-full">
		
		<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>
			<p><?php printf( __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'tweaker5' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>
		<?php else: ?>
			<p><?php printf( __( 'It appears as if you are in a bit of a rush, no posts have been posted as yet.', 'tweaker5' )) ; ?>
		<?php endif; ?>
        
	</div><?php // close .content-full ?>

</section><?php // close .no-results ??>
