<?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments
 * and the comment form. The actual display of comments is
 * handled by a callback to tweaker5_comment() which is
 * located in the inc/template-tags.php file.
 *
 * @package tweaker5
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

	<?php // You can start editing here -- including this comment! ?>

	<?php if ( have_comments() ) : ?>
		<h2 class="h3-size comments-title">
			<?php
				printf( _nx( 'One thought on &ldquo;%2$s&rdquo;', '%1$s thoughts on &ldquo;%2$s&rdquo;', get_comments_number(), 'comments title', 'tweaker5' ),
					number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' );
			?>
		</h2>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
			<div class="comment-navigation">
				<?php paginate_comments_links(); ?>
            </div>
		<?php endif; // check for comment navigation ?>

		<ol class="comment-list">
			<?php
				/* Loop through and list the comments. Tell wp_list_comments()
				 * to use tweaker5_comment() to format the comments.
				 * If you want to override this in a child theme, then you can
				 * define tweaker5_comment() and that will be used instead.
				 * See tweaker5_comment() in inc/template-tags.php for more.
				 */
				wp_list_comments( array( 'callback' => 'tweaker5_comment', 'avatar_size' => 36 ) );
			?>
		</ol><?php //close .comment-list ?>

		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : // are there comments to navigate through ?>
			<div class="comment-navigation">
				<?php paginate_comments_links(); ?>
            </div><?php //close .comment-navigation ?>
		<?php endif; // check for comment navigation ?>

	<?php endif; // have_comments() ?>

	<?php
	// If comments are closed and there are comments, let's leave a little note, shall we?
	if ( ! comments_open() && '0' != get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) :
	?>
		<p class="no-comments"><?php _e( 'Comments are closed.', 'tweaker5' ); ?></p>
	<?php endif; ?>
	
    <?php $required_text = __( ' Required fields are marked <span class="required"></span>', 'tweaker5' ); ?>
    
    <?php $tweaker5_comment_args = array( 'fields' => apply_filters( 'comment_form_default_fields', array(
	'author' => '<p class="comment-form-author">' .
                '<label for="author">' . __( 'Name', 'tweaker5' ) . '</label> ' .
                ( $req ? '<span class="required"></span>' : '' ) .
                '<input id="author" name="author" type="text" value="' .
                esc_attr( $commenter['comment_author'] ) . '"  />' .
                '</p>',
    'email'  => '<p class="comment-form-email">' .
                '<label for="email">' . __( 'Email', 'tweaker5' ) . '</label> ' .
                ( $req ? '<span class="required"></span>' : '' ) .
                '<input id="email" name="email" type="text" value="' . 
				esc_attr(  $commenter['comment_author_email'] ) . '" />' .
				'</p>',
    'url'    => '<p class="comment-form-url">' .
				'<label for="url">' . __( 'Website', 'tweaker5' ) . '</label>' .
	            '<input id="url" name="url" type="text" value="' . esc_attr( $commenter['comment_author_url'] ) . '" /></p>' ) ),
    'comment_field' => '<p class="comment-form-comment">' .
                '<label for="comment">' . __( 'Comment', 'tweaker5' ) . '</label> ' .
				( $req ? '<span class="required"></span>' : '' ) .
                '<textarea id="comment" name="comment" rows="8"></textarea>' .
                '</p>',
    'comment_notes_after' => '',
	'title_reply'=> __( 'Leave a Reply', 'tweaker5' ),
	'logged_in_as'=> '<p class="logged-in-as">' . sprintf( __( 'Logged in as <a href="%1$s">%2$s</a>. <a href="%3$s" title="Log out of this account">Log out?</a>', 'tweaker5' ), admin_url( 'profile.php' ), $user_identity, wp_logout_url( apply_filters( 'the_permalink', get_permalink() ) ) ) . '</p>',
	'label_submit'=> __( 'Post Comment', 'tweaker5' ),
	'comment_notes_before'=> '<p class="comment-notes">' . __( 'Your email address will not be published.', 'tweaker5' ) . ( $req ? $required_text : '' ) . '</p>',
	'must_log_in' => '<p class="must-log-in">' .  sprintf( __( 'You must be <a href="%s">logged in</a> to post a comment.', 'tweaker5' ), wp_login_url( apply_filters( 'the_permalink', get_permalink() ) ) ) . '</p>',
	'cancel_reply_link' => __( 'Cancel reply', 'tweaker5' ),
	); ?>
    
	<?php comment_form($tweaker5_comment_args); ?>

</div><?php // close #comments ?>