<?php
/**
 * Tweaker5 Archive Pages
 * @package tweaker5
 *
 */?>

<?php get_header(); ?>
        
	<?php if(is_active_sidebar( 'blog-sidebar' )): ?>
        <section class="col grid-8 site-content">
    <?php else: ?>
        <section class="col grid-12 site-content">
    <?php endif; ?>

    <?php if ( have_posts() ) : ?>

        <header class="content-header">
            <h1>
                <?php
                    if ( is_category() ) :
                        single_cat_title();

                    elseif ( is_tag() ) :
                        single_tag_title();
                        
                    elseif ( is_author() ) :
                        echo get_the_author();

                    elseif ( is_day() ) :
                        printf( __( 'Day: %s', 'tweaker5' ), '<span>' . get_the_date() . '</span>' );

                    elseif ( is_month() ) :
                        printf( __( 'Month: %s', 'tweaker5' ), '<span>' . get_the_date( _x( 'F Y', 'monthly archives date format', 'tweaker5' ) ) . '</span>' );

                    elseif ( is_year() ) :
                        printf( __( 'Year: %s', 'tweaker5' ), '<span>' . get_the_date( _x( 'Y', 'yearly archives date format', 'tweaker5' ) ) . '</span>' );

                    elseif ( is_tax( 'post_format', 'post-format-aside' ) ) :
                        _e( 'Asides', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-gallery' ) ) :
                        _e( 'Galleries', 'tweaker5');

                    elseif ( is_tax( 'post_format', 'post-format-image' ) ) :
                        _e( 'Images', 'tweaker5');

                    elseif ( is_tax( 'post_format', 'post-format-video' ) ) :
                        _e( 'Videos', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-quote' ) ) :
                        _e( 'Quotes', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-link' ) ) :
                        _e( 'Links', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-status' ) ) :
                        _e( 'Statuses', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-audio' ) ) :
                        _e( 'Audios', 'tweaker5' );

                    elseif ( is_tax( 'post_format', 'post-format-chat' ) ) :
                        _e( 'Chats', 'tweaker5' );

                    else :
                        _e( 'Archives', 'tweaker5' );

                    endif;
                ?>
            </h1>
            </header><?php //close .content-header ?>
            <?php
                // Show an optional term description.
                $term_description = term_description();
                if ( ! empty( $term_description ) ) : ?>
                    <?php printf( '<div class="taxonomy-description">%s</div>', $term_description ); ?>
                <?php endif;
            ?>
        

        <?php /* Start the Loop */ ?>
        <?php while ( have_posts() ) : the_post(); ?>

            <?php
                /* Include the Post-Format-specific template for the content.
                 * If you want to override this in a child theme, then include a file
                 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                 */
                get_template_part( 'content', get_post_format() );
            ?>

        <?php endwhile; ?>

        <?php if (tweaker5_show_posts_nav()) : ?>
                <div class="paginate">
                    <?php tweaker5_paginate(); ?>
                </div><?php // close .paginate ?>
            <?php endif; ?>
            <!-- replace the entire if statement above with '< ?php tweaker5_paging_nav(); ? >' 
            should you prefer the old style navigation. Please remove the spaces from the 
            opening and closing brackets. -->

    <?php else : ?>

        <?php get_template_part( 'content', 'none' ); ?>

    <?php endif; ?>

	</section><?php // close .site-content ?>

    <?php if(is_active_sidebar( 'blog-sidebar' )): ?>
        <?php get_sidebar(); ?>
    <?php endif; ?>
		
<?php get_footer(); ?>