<?php
/**
 * The main template file. index.php
 *
 * To display a page when nothing more specific matches a query.
 * For example, it compiles the home page when no home.php file exists.
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage tswplain
 * @since tswplain 3.04
 */
 
get_header(); ?>
<div class="wrap">
    <div class="grids">
        <section class="grid-10">
            <article class="grid-7" role="main">
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php if(have_posts()) : ?>
                    <?php while(have_posts()) : the_post(); ?>
                <div class="post">
<h3 class="blog-post-title"><a href="<?php the_permalink(); ?>" title="<?php the_permalink(); ?>"><?php the_title(); ?> &#9734;</a></h3>
                    <div class="entry">   
                        <?php the_post_thumbnail(); ?>
                        <?php the_content(); ?>
                        <p class="postmetadata">
                        <?php comments_popup_link(); ?> &nbsp;<?php edit_post_link(); ?>
                        </p>
                    </div>
                </div>
                    <?php endwhile; ?>
                <div class="navigation">
                <?php posts_nav_link(); ?>
                </div>          
        <?php comment_form(); ?>       
        <?php endif; ?>
            </article>
                <article class="grid-3"><?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
                    <div id="primary-sidebar">	
                        <?php dynamic_sidebar( 'sidebar-1' ); ?>
                    </div>
                        <?php endif; ?>
                </article>
        </section>
    </div><!-- ends main -->
</div><!-- ends grids -->
<?php get_footer(); ?>