<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<title>
<?php wp_title(); ?>
</title>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11" />	
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js" type="text/javascript"></script>
<![endif]-->
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>> 
<div id="wrapper">
    <header class="header">
        <nav>
        <?php wp_nav_menu ( array( 'theme_location' => 'header-menu' ) ); ?>
        </nav>
            <h1 class="blog-title">
<a href="<?php echo esc_url( home_url() ); ?>" title="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?> &mdash; <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>" rel="home"><?php echo esc_attr( get_bloginfo( 'title' ) ); ?> </a>
            </h1>
                <figure class="logo"> <?php if (get_header_image() != '') { ?>  
<a href="<?php echo esc_url( home_url() ); ?>" title="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?> - <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>" rel="home">
<img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?>" /></a><?php } else { ?> &nbsp; <?php } ?>
                </figure>
                    <?php if ( is_active_sidebar( 'header-sidebar' ) ) : ?>
	            <aside id="widget-area-header">
		        <?php dynamic_sidebar( 'header-sidebar' ); ?>
	            </aside>               
                    <?php endif; ?>
                        <h2 class="site-description"><?php echo get_bloginfo( 'description' ); ?></h2>
    </header> <!-- ends header section -->