<?php
/*
 * TSWPlain Theme's Functions file, this is the heart of theme, modification directly is not recommended.
 * TSWPlain custom Theme functions do not run well and are not supported below WordPress versions 3.4
 * TSWPlain Supports Child Themes.
 * Use a child theme for customization (see http://codex.wordpress.org/Theme_Development and
 * http://codex.wordpress.org/Child_Themes).
 * You can easily add another file nemed functions.php in your Child-Theme and it will add that file
 * to the end of this files actions.
 * @package WordPress - n/a
 * @subpackage tswplain
 * @since tswplain 4.0
 * © 2014 Larry Judd, tradesouthwest.com
 */
 
if ( ! isset( $content_width ) )
	$content_width = 800;

/**
 * Tell WordPress to run tswplain_setup() when the 'after_setup_theme' hook is run.
 */
function tswplain_setup() {

        // language support - add your translation to this page /languages/tswplain.pot
        load_theme_textdomain('tswplain', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );
	
        // This theme uses wp_nav_menu() in Header only.
        register_nav_menu('header-menu', __( 'Header Menu', 'tswplain' ));
        
        // This theme uses Featured Images (also known as post thumbnails)
        add_theme_support( 'post-thumbnails' );

        // add tag support to pages
	register_taxonomy_for_object_type('post_tag', 'page');
        
        // custom editor style support
        add_editor_style( 'custom-editor-style.css' );

        // customer background color support 
    add_theme_support( 'custom-background', array(
    'default-color'          => 'FAFAFB',
    'default-image'          => get_template_directory_uri() . '/images/default_background.png',	
    ) );
    
        // customer header image banner support 
    add_theme_support( 'custom-header', array(

	'default-image'          => get_template_directory_uri() . '/images/header3.png',
	'random-default'         => false,
 	'width'                  => 780,
	'height'                 => 163,
	'flex-height'            => false,
 	'flex-width'             => false,
 	'default-text-color'     => 'FFF',
	'header-text'            => false,
	'uploads'                => true,
        'wp-head-callback'       => '',
	'admin-head-callback'    => '',
	'admin-preview-callback' => ''
    ) );

}
  
add_action( 'after_setup_theme', 'tswplain_setup' );

     
    /*
     * Enqueue scripts and styles for front-end.
     * @since tswplain 2.0
     * @return void
     */
function tswplain_scripts_styles() {

     /*
      * Adds JavaScript to pages with the comment form to support
      * sites with threaded comments (when in use).
      */
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
	wp_enqueue_script( 'comment-reply' );

        // Loads default main stylesheet.
        wp_enqueue_style( 'tswplain-style', get_stylesheet_uri() );   
}

add_action( 'wp_enqueue_scripts', 'tswplain_scripts_styles' );

   

    /*
     * Registers our main widget area and the footer widget areas.
     */     
function tswplain_widgets_init() {

register_sidebar( array(
    'name' =>  __('Right Side Widget', 'tswplain'),
    'id' => 'sidebar-1',
    'description' => __('Appears on posts and pages in Footer Area Left', 'tswplain'),
    'before_widget' => '<div class="widget-area-primary">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
	 ) );

register_sidebar( array(
    'name' => __('Footer Widget 1', 'tswplain'),
    'id' => 'sidebar-2',
    'description' => __('Appears Left Side on Footer', 'tswplain'),
    'before_widget' => '<div class="widget-area-secondary">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );

register_sidebar( array(
    'name' => __('Footer Widget 2', 'tswplain'),
    'id' => 'sidebar-3',
    'description' => __('Appears on Footer Middle', 'tswplain'),
    'before_widget' => '<div class="widget-area-secondary">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );
register_sidebar( array(
    'name' => __('Footer Widget 3', 'tswplain'),
    'id' => 'sidebar-4',
    'description' => __('Appears on Footer Right', 'tswplain'),
    'before_widget' => '<div class="widget-area-secondary">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );
register_sidebar( array(
    'name' => __('Right Header Logo Widget', 'tswplain'),
    'id' => 'header-sidebar',
    'description' => __('Optional Header Area Right - Max Height = 250 pixels Only 1 Widget allowed', 'tswplain'),
    'before_widget' => '<div class="widget-area-header">',
    'after_widget' => '</div>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );
}
add_action( 'widgets_init', 'tswplain_widgets_init' );

/* 
 * This filter sets all fonts to the same size to keep the header-widget
 * contained when using tag cloud in the header-widget. Change arguments for 'smallest' 'largest'
 * to use in other widgets to make font sizes various sizes. 18 and 9 are good sizes.
 */
 
add_filter( 'widget_tag_cloud_args', 'tswplain_widget_tag_cloud_args' );
function tswplain_widget_tag_cloud_args( $args ) {
	// Your extra arguments go here
	$args['number']   = 25;
	$args['largest']  = 11;
	$args['smallest'] = 11;
	$args['unit']     = 'px';
	return $args;
}

/*
 * WordPress body class Extender :
 * 1. Using a full-width layout without widgets.
 *
 * @since tswplain 2.0
 */

    function tswplain_content_width() {
	if ( is_page_template( 'full-width.php' ) || is_attachment() || ! is_active_sidebar( 'tswplain-sidebar' ) ) {
		global $content_width;
		$content_width = 1040;
	}
    }
add_action( 'template_redirect', 'tswplain_content_width' );

?>