<?php 
/* archive.php
 * Theme: tswplain
 */

get_header(); ?>
<div id="wrapper">
    <div class="grids">
        <section class="grid-10">
            <nav>
            <?php wp_nav_menu ( array( 'theme_location' => 'header-menu' ) ); ?>
            </nav>
            <article class="grid-7" role="main">
            <h4><?php printf( __( 'Category for Archives: %s', 'tswplain' ), single_cat_title( '', false ) ) ); ?></h4>
                <?php echo $page_class; ?>
                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
<h4>
<?php printf( __( 'Yearly Archives: %s', 'tswplain' ), get_the_date( _x( 'Y', 'yearly archives date format', 'tswplain' ) ) ); ?>
</h4>
<ul><?php wp_get_archives('type=yearly'); ?></ul>
<h4>
<?php printf( __( 'Monthly Archives: %s', 'tswplain' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'tswplain' ) ) ); ?>
</h4>
<ul><?php wp_get_archives('type=monthly'); ?></ul>
			<div class="navigation"><p><?php posts_nav_link(' '); ?></p></div>
            </article>
<article class="grid-3"><?php if ( is_active_sidebar( 'sidebar-1' ) ) : ?>
                    <div id="primary-sidebar">	
                        <?php dynamic_sidebar( 'sidebar-1' ); ?>
                    </div>
                        <?php endif; ?>
                </article>
        </section>
    </div><!-- ends grids -->
</div><!-- ends wrap -->
<?php get_footer(); ?>