<?php
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) {
	exit;
}
/*
 * @tswebiz
 *
 * Admin Options for tswebiz 
 * File Name: theme-options.php
 */
$tswebiz_theme_options = array(
    'phonenumber'     => '',
    'tswebiz_email'   => '',
    'facebookurl'     => '',
    'twitterurl'      => '',
    'googleurl'       => '',
    'linkedinurl'     => '',
    'backgrnd'        => '',
    'tswebiz_confirm' => '',
    'tswebiz_credits' => '',
    'tswebiz_new_text' => ''
    );

add_action( 'admin_menu', 'tswebiz_options_add_page' ); 
function tswebiz_options_add_page() {
    add_theme_page( 'tswebiz Options', 'TSWeBiz Options', 'edit_theme_options', 'tswebiz-options', 'tswebiz_options_page' );
}
// connect stylesheet to options page
function tswebiz_add_init() {
    wp_enqueue_style( 'tswebiz-admin-style', get_template_directory_uri() . '/include/admin-style.css', false, '1.1' );
    }
add_action( 'admin_enqueue_scripts', 'tswebiz_add_init' );

function tswebiz_register_settings() {
        register_setting( 'tswebiz-options', 'tswebiz_theme_options', '');
    } 
    add_action( 'admin_init', 'tswebiz_register_settings' );
/*
 * color picker add on
 */
add_action( 'admin_enqueue_scripts', 'tswebiz_add_color_picker' );
function tswebiz_add_color_picker() {
    // Add the color picker css file       
    wp_enqueue_style( 'wp-color-picker' ); 
    // Include our custom jQuery file with WordPress Color Picker dependency
    wp_enqueue_script( 'wp-color-picker-script', get_template_directory_uri() . '/js/custom-script.js', array( 'wp-color-picker' ), false, true );
}

function tswebiz_options_page() {
    global $tswebiz_theme_options;
?>
<div class="options-container">
    <figure> <h1><?php _e( 'Options Page', 'tswebiz' ); ?> </h1>  </figure>
	<h2><?php _e( 'TSWeBiz Theme Settings', 'tswebiz' ); ?></h2>

	    <p><?php _e( 'Update Sidebar Background Color - Alter Post Header - Add your Personal Links - Change Footer Text', 'tswebiz' ); ?></p>
	        <form action="options.php" method="POST">
            <?php settings_fields( 'tswebiz-options' ); ?>
            <?php //do_settings_sections( 'tswebiz-options' ); 
            $options = get_option( 'tswebiz_theme_options', $tswebiz_theme_options );
            ?>
            <hr>         
                <h3><?php _e( 'Add your social media links here', 'tswebiz' ); ?></h3>
                    <table class="options-table">
        <tr><td><label><?php _e( 'Phone Number', 'tswebiz' ); ?></label> </td><td> 
<input type="text" name="tswebiz_theme_options[phonenumber]" size="40"  value="<?php echo $options['phonenumber']; ?>" /></td></tr>
        <tr><td><label><?php _e( 'Email Address', 'tswebiz' ); ?></label> </td><td> 
<input type="text" name="tswebiz_theme_options[tswebiz_email]" size="40" value="<?php echo $options['tswebiz_email']; ?>" /></td></tr>
        <tr><td><label>Facebook</label> </td><td>
<input type="text" name="tswebiz_theme_options[facebookurl]" size="40"   value="<?php echo $options['facebookurl']; ?>" /></td></tr>
        <tr><td><label>Twitter</label> </td><td>
<input type="text" name="tswebiz_theme_options[twitterurl]" size="40"    value="<?php echo $options['twitterurl']; ?>" /></td></tr>
        <tr><td><label>Google</label> </td><td>
<input type="text" name="tswebiz_theme_options[googleurl]" size="40"     value="<?php echo $options['googleurl']; ?>" /></td></tr> 
        <tr><td><label>LinkedIn</label> </td><td>
<input type="text" name="tswebiz_theme_options[linkedinurl]" size="40"   value="<?php echo $options['linkedinurl']; ?>" /></td></tr> <tr><td colspan=2><small><?php _e( 'Do not include the ', 'tswebiz' ); ?> <code class="notes">http:// ~ https://</code></small></td></tr>     
                    </table>
                        <hr>
        <h3><?php _e( 'Color for Sidebar-Left Background can be set here', 'tswebiz' ); ?></h3>
                        <table class="options-table">
                        <tr><td><label><?php _e( 'Change Sidebar-Left Background Color', 'tswebiz' ); ?></label>
<input type="text" name="tswebiz_theme_options[backgrnd]" size="20" value="<?php echo $options['backgrnd']; ?>" class="tswebiz-color-field" data-default-color="rgba(255,255,255,0.1)" /></td></tr>
                        </table>
                            <hr>         
                                <h3><?php _e( 'Remove Title Date and Metadata from Home Page Article', 'tswebiz' ); ?></h3>
                                    <table class="options-table">
        <tr><td><h4><?php _e( 'Type in <code>none</code> to confirm. OR delete <code>none</code> to display.', 'tswebiz' ); ?></h4> 
        <input name="tswebiz_theme_options[tswebiz_confirm]" size="10" type="text" id="tswebiz_confirm"  
        value="<?php echo $options['tswebiz_confirm']; ?>" /></td></tr>
        <tr><td><?php _e( 'You may write title in manually at the beginning of the lead article.<br>
Option provides a way to remove the word home from a static home page.', 'tswebiz' ); ?></td></tr>
                                </table>
                                    <hr>
                                        <h3><?php _e( 'Check box to remove credits from theme footer section.', 'tswebiz' ); ?></h3>
                                            <?php  if ( !empty( $options['tswebiz_credits'] )) {
                                            $checked = $options['tswebiz_credits'];
                                            $current = "checked = checked"; } else { $current = ""; }
                                            ?>
                <table><tr><td><input name="tswebiz_theme_options[tswebiz_credits]" id="tswebiz_credits" type="checkbox" 
                value="1" <?php echo $current; ?> />
                <small><?php _e( 'You do not have to leave footer credits but it would be nice.', 'tswebiz' ); ?></small></td></tr>
                <tr><td><p><?php _e( 'Replace the footer credit with your own text here', 'tswebiz' ); ?></p>
                <input id="tswebiz_new_text" name="tswebiz_theme_options[tswebiz_new_text]" size="40" type="text" 
value="<?php if (!empty($options['tswebiz_new_text'])) echo $options['tswebiz_new_text']; ?>" /></td></tr>
                </table>
    <?php submit_button(); ?>
                </form>
</div>
<?php 
}

function tswebiz_validate_options( $input ) {
      
        // We strip all tags from the text field, to avoid vulnerablilties like XSS
        $input['phonenumber']      = wp_filter_post_kses( $input['phonenumber'] );
        $input['tswebiz_email']    = wp_filter_post_kses( $input['tswebiz_email'] );
        $input['facebookurl']      = wp_filter_post_kses( $input['facebookurl'] );
        $input['twitterurl']       = wp_filter_post_kses( $input['twitterurl'] );
        $input['googleurl']        = wp_filter_post_kses( $input['googleurl'] );
        $input['linkedinurl']      = wp_filter_post_kses( $input['linkedinurl'] );
        $input['backgrnd']         = wp_filter_post_kses( $input['backgrnd'] );
        $input['tswebiz_confirm']  = wp_filter_post_kses( $input['tswebiz_confirm'] );
        $input['tswebiz_credits']  = wp_filter_post_kses( $input['tswebiz_credits'] );
        $input['tswebiz_new_text'] = sanitize_text_field( $input['tswebiz_new_text'] );
           return $input;
    }

// create custom background style for sidebar
function tswebiz_styles_method() {
    wp_enqueue_style(
    'custom-style',
    get_template_directory_uri() . '/include/custom.css'
    ); 
        $options = get_option( 'tswebiz_theme_options' );

        $custom_css = "
            #sidebar-left {
                background: {$options['backgrnd']};
        }";
        $custom_css = "
             body.home header.post-header {
             display: {$options['tswebiz_confirm']};
        }";              
    wp_add_inline_style( 'custom-style', $custom_css );
}
add_action( 'wp_enqueue_scripts', 'tswebiz_styles_method' );

?>