<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<title><?php wp_title(); ?></title>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
    <nav class="top-bar">
        <?php wp_nav_menu ( array( 'theme_location' => 'topbar-menu' ) ); ?>
    </nav>
    <header class="header">
        <nav class="menu-right">
            <?php if (has_nav_menu('header-menu')) { wp_nav_menu ( array( 'theme_location' => 'header-menu' ) ); } 
                  else { echo "<div class='no_menu'> </div>"; } ?>
        </nav>  
            <hgroup>
                <h1 class="site-title"><a href="<?php echo esc_url( home_url() ); ?>" title="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?> &mdash; <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>" rel="home"><?php echo esc_attr( get_bloginfo( 'title' ) ); ?> </a></h1>
<!-- <img class="logo-top" src="<?php echo get_template_directory_uri() . '/images/header-image.png'; ?>" /> -->
            </hgroup>    
                <figure class="logo">   
                    <a href="<?php echo esc_url( home_url() ); ?>" title="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?>  &mdash; <?php echo esc_attr( get_bloginfo( 'description' ) ); ?>" rel="home"><img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="<?php echo esc_attr( get_bloginfo( 'title' ) ); ?>" /></a>
                </figure> 
                    <h2 class="site-description">
                        <?php if ( is_single() ) {
                              single_post_title('', true); 
                              } else {
                              bloginfo('description');
                              } ?>
                    </h2>              
    </header> <!-- ends header section -->
        <div class="breaker"> </div>