<?php
/*
 * Use a child theme for customization (see http://codex.wordpress.org/Theme_Development and
 * http://codex.wordpress.org/Child_Themes).
 * @package WordPress - n/a
 * @subpackage tswebiz
 * @since tswebiz 1.0
 * © 2014 Larry Judd, Tradesouthwest.com
 */

include_once (get_template_directory() . '/include/theme-options.php');

// run setup functions 'after_setup_theme' hook is run.
function tswebiz_setup() {

    // set width of external linked media players not defined
      global $content_width;
    if ( !isset( $content_width  ) ) {
        $content_width  = 720;
    }

        // language support - add your translation to this page /languages/tswebiz.pot
        load_theme_textdomain('tswebiz', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head
	add_theme_support( 'automatic-feed-links' );

        
        // This theme uses Featured Images (also known as post thumbnails)
        add_theme_support( 'post-thumbnails' );
        
        // custom editor style support
        add_editor_style( 'custom-editor-style.css' );

    // This theme uses wp_nav_menu() in Header and Top-Bar.
        register_nav_menus( array(
            'header-menu' => __( 'Header Menu', 'tswebiz' ),
            'topbar-menu' => __( 'Top-Bar Menu Inline ONLY No Stacks', 'tswebiz' )
        ));

}
add_action( 'after_setup_theme', 'tswebiz_setup' );

    /*
     * Enqueue scripts and styles for front-end.
     * @since tswebiz 1.0
     */
function tswebiz_scripts_styles() {
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) )
	wp_enqueue_script( 'comment-reply' );

        // Loads default main stylesheet.
        wp_enqueue_style( 'tswebiz-style', get_stylesheet_uri() );
        // toggle reply comment form script
        wp_enqueue_script( 'tswebiz', get_template_directory_uri() . '/js/toggle.js', 
        array( 'jquery' ), '1.0', true
        );
}
    add_action( 'wp_enqueue_scripts', 'tswebiz_scripts_styles' );

        // add ie conditional html5 shim to header
function tswebiz_add_ie_html5_shim () {
    echo '<!--[if lt IE 9]>';
    echo '<script src="js/html5.js"></script>';
    echo '<![endif]-->';
}
    add_action('wp_head', 'tswebiz_add_ie_html5_shim');

    // font imported
    add_action( 'tswebiz', 'wpb_add_google_fonts', 5);
    function tswebiz_add_google_fonts() {
    echo "<link href='http://fonts.googleapis.com/css?family=Yanone+Kaffeesatz:400,300,700' rel='stylesheet' type='text/css'>";
    }

     // customer header image banner support 

    add_theme_support( 'custom-header' );
        $defaults = array(
	'default-image'          => get_template_directory_uri() . '/images/default_header.png',
	'random-default'         => false,
 	'width'                  => 700,
	'height'                 => 400,
	'flex-height'            => false,
 	'flex-width'             => false,
 	'default-text-color'     => 'FFFFFF',
	'header-text'            => false,
	'uploads'                => true,
        'wp-head-callback'       => '',
	'admin-head-callback'    => '',
	'admin-preview-callback' => '',        
    );
    add_theme_support( 'custom-header', $defaults );

    // customer background color support 
    add_theme_support( 'custom-background' );
    $args = array(
    'default-color'          => 'FAFAFB',
    'default-image'          => get_template_directory_uri() . '/images/default_background.jpg',	
    );
    add_theme_support( 'custom-background', $args );

    //custom footer credits option
function tswebiz_footer_credits() {
    echo '<p><a href="http://www.tradesouthwest.com/"> <small>Theme TSWeBiz by Tradesouthwest</small></a></p>';
}
add_action( 'tswebiz_footer_credits', 'tswebiz_footer_credits' );
    
    //Registers our main widget area and the footer widget areas.     
function tswebiz_widgets_init() {

register_sidebar( array(
    'name' =>  __('Left Side Widget', 'tswebiz'),
    'id' => 'sidebar-1',
    'description' => __('Appears on posts and pages in Footer Area Left', 'tswebiz'),
    'before_widget' => '<aside class="widget-area-primary">',
    'after_widget' => '</aside>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
	 ) );

register_sidebar( array(
    'name' => __('Footer Widget 1', 'tswebiz'),
    'id' => 'sidebar-2',
    'description' => __('Appears Left Side on Footer', 'tswebiz'), 
    'before_widget' => '<aside class="widget-area-secondary">',
    'after_widget' => '</aside>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );

register_sidebar( array(
    'name' => __('Footer Widget 2', 'tswebiz'),
    'id' => 'sidebar-3',
    'description' => __('Appears on Footer Middle', 'tswebiz'),
    'before_widget' => '<aside class="widget-area-secondary">',
    'after_widget' => '</aside>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );
register_sidebar( array(
    'name' => __('Footer Widget 3', 'tswebiz'),
    'id' => 'sidebar-4',
    'description' => __('Appears on Footer Right', 'tswebiz'),
    'before_widget' => '<aside class="widget-area-secondary">',
    'after_widget' => '</aside>',
    'before_title' => '<h3 class="widget-title">',
    'after_title' => '</h3>',
) );

}

add_action( 'widgets_init', 'tswebiz_widgets_init' );

?>