<?php
/**
 * Template name: Single Posts
 * single.php
 * @package TSW
 * @since TSW 1.0
 */
 
get_header(); ?>
            <section id="primary" class="content-area" role="main">
                <div id="post" <?php post_class(); ?>>
                <?php if(have_posts()): ?>
                    <?php while(have_posts()): the_post() ?>
                    <header class="entry-header">
                      <h1 class="entry-title"><?php echo the_title(); ?></h1>
                      <?php _e( 'Posted by', 'tsw' ); ?> <?php the_author(); ?> - <?php the_time(__('M-d-Y', 'tsw' ) ) //American Format ?>
                    </header>
                        <article class="entry-content">
                          <?php if ( has_post_thumbnail() ) {
                	    the_post_thumbnail(); 
                          } 
                              the_content(); ?>
                                <p class="edit-link"><?php edit_post_link( __( 'Edit', 'tsw' ) ); ?></p>
                                <p class="tag-link"><?php the_tags( __( 'Tags: ', 'tsw' ) ); ?></p>
                                <div><span class="cat-link"><?php _e( 'In:', 'tsw' ); ?> </span><?php the_category(); ?>
                                </div>
                        </article>
                </div><!-- ends post -->
                    <?php endwhile; ?>
                    <?php comments_template(); ?>
                        <div class="navigation">
                        <p><span class="nav-next"><?php next_post_link( '%link', '%title &raquo;' ) ?></span> | 
                        <span class="nav-previous"><?php previous_post_link( '%link', '&laquo; %title' ) ?></span></p>
                        </div>              
                <?php endif; ?>
           </section><!-- #primary .content-area -->
<?php get_sidebar(); ?>
<?php get_footer(); ?>