<?php
/**
 * The template for displaying all pages.
 * page.php
 * @package TSW
 * @since TSW 1.0
 */
 
get_header(); ?>
        <section id="primary" class="content-area" role="main">
            <?php if ( have_posts() ) : ?>
                <?php while ( have_posts() ) : the_post(); ?>
                <div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <header class="entry-header">
                        <h1 class="entry-title">
                        <a href="<?php the_permalink() ?>" rel="bookmark" title="<?php the_title_attribute(); ?>">
                        <?php the_title(); ?></a></h1>
                    </header>
                    <article class="entry-content">
                        <?php the_content(); ?><?php wp_link_pages(); ?>
                        <?php edit_post_link( __( 'Edit', 'tsw' ), '<span class="edit-link">', '</span>' ); ?>
                    </article><!-- .entry-content -->
                </div><!-- #post -->
                <?php endwhile; // end of the loop. ?>
                <div class="nav-previous"><?php next_posts_link(); ?></div>
		<div class="nav-next"><?php previous_posts_link(); ?></div>
                            <?php comments_template(); ?>
            <?php else : ?>
            <p><?php _e( 'Nothing matched your criteria.', 'tsw' ); ?></p>
            <?php endif; ?>
        </section><!-- #primary .content-area -->                   
            <?php get_sidebar('primary-sidebar'); ?>
            <?php get_footer(); ?>