<?php
/**
 * @package tsw
 * @since tsw 1.1
 */
?><!DOCTYPE html>
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 8) ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width">
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<!--[if lt IE 9]>
<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
<![endif]-->
<?php if ( is_singular() ) wp_enqueue_script( 'comment-reply' ); ?>
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<section class="site-header">
    <header id="masthead" role="banner">
        <hgroup>
            <h1 class="site-title"><a href="<?php echo home_url( '/' ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
            <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
        </hgroup>           
    </header><!-- ends masthead -->
        <section role="navigation" id="main-nav">
            <h1 class="assistive-text"><?php _e( 'Menu', 'tsw' ); ?></h1>
                <div class="assistive-text skip-link">
                    <a href="#content" title="<?php esc_attr_e( 'Skip to content', 'tsw' ); ?>">
                    <?php _e( 'Skip to content', 'tsw' ); ?></a>
                </div>
            <nav class="main-navigation">
            <?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
            </nav>
        </section><!-- ends main-navigation -->
</section><!-- ends site-header -->
     <div id="main" class="site-main">