<?php
/**
 * TSW functions and definitions
 *
 * @package TSW
 * @since TSW 0.1
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 *
 * @since TSW 0.1
 */
if ( ! isset( $content_width ) )
    $content_width = 720; /* pixels */

function tsw_setup() {

    //Make theme available for translation
    load_theme_textdomain( 'tsw', get_template_directory() . '/languages' );
 
    //Add default posts and comments RSS feed links to head
    add_theme_support( 'automatic-feed-links' );
    
    // This theme supports Featured Image in posts
    add_theme_support( 'post-thumbnails' );
 
    //Enable support for the Aside Post Format
    add_theme_support( 'post-formats', array( 'aside', 'status', 'gallery' ) );
    
    //Enable support for site background change
    $args = array(
	'default-color' => 'f5f5f5',
	'default-image' => get_template_directory_uri() . '/images/background.png',
    );
    add_theme_support( 'custom-background', $args );
    
    //This theme uses wp_nav_menu() in one location.
    register_nav_menus( array(
        'primary' => __( 'Primary Menu', 'tsw' ),
    ) );
}

add_action( 'after_setup_theme', 'tsw_setup' );

/**
 * Enqueue scripts and styles
 */
function tsw_scripts() {
    wp_enqueue_style( 'style', get_stylesheet_uri() );
}
add_action( 'wp_enqueue_scripts', 'tsw_scripts' );
 
    /**
     * Register widgetized area and update sidebar with default widgets
     *
     * @since TSW 0.1
     */
function tsw_widgets_init() {
    register_sidebar( array(
        'name' => __( 'Single Left-Side Widget Area', 'tsw' ),
        'id' => 'sidebar-1',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<header class="widget-header">',
        'after_title' => '</header>'
    ) );
}

add_action( 'widgets_init', 'tsw_widgets_init' );

    /**
     * WordPress body class Extender :
     * Page using a full-width layout without widgets.
     *
     * @since TSW 0.1
     */

    function tsw_content_width() {
	if ( is_page_template( 'full-width.php' ) || is_attachment() || ! is_active_sidebar( 'tsw_tsw-sidebar' ) ) {
		global $content_width;
		$content_width = 1040;
	}
    }
add_action( 'template_redirect', 'tsw_content_width' );

?>