<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package trustnews
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<?php 
	//wp_body_open hook from WordPress 5.2
	if ( function_exists( 'wp_body_open' ) ) {
	    wp_body_open();
	} else {
		do_action( 'wp_body_open' );
	} ?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'trustnews' ); ?></a>
	<?php
	if ( has_header_image() ) {
		/**
		* Header Image
		*/
		do_action ('trustnews_frontend_header_image');
	}

		$disable_search_form = get_theme_mod('disable_search_form',0);
		$disable_breaking_news = get_theme_mod('disable_breaking_news',0);
		$upload_header_brand = get_theme_mod ('upload_header_brand','');
		$enable_advertise_area = get_theme_mod ('enable_advertise_area',0);

	if ( ( is_front_page() && is_home() ) || is_front_page() || ($enable_advertise_area == 1) ) {
		// Default homepage
		if ( is_active_sidebar( 'advertise-area' ) ) { ?>
			<div class="advertise-area">
				<div class="wrap">

					<?php dynamic_sidebar( 'advertise-area' ); ?>

				</div><!-- .wrap -->
			</div><!-- .advertise-area -->

		<?php }
	} ?>

	<header id="masthead" class="site-header">
		<div id="main-header" class="main-header">
			<div class="navigation-top">
        		<div class="wrap">
            	<div id="site-header-menu" class="site-header-menu">
               	<nav class="main-navigation" aria-label="<?php esc_attr_e('Primary Menu','trustnews'); ?>" role="navigation">
							<?php
								/**
								 * Top Navigation
								 */
								do_action('trustnews_frontend_navigation_top'); 
							?>
						 </nav><!-- #site-navigation -->
						 <?php if($disable_search_form ==0) { ?>
									<button type="button" class="search-toggle"><span><span class="screen-reader-text"><?php esc_html_e('Search for:','trustnews'); ?></span></span></button>
								<?php } ?>
           		</div>
        		</div><!-- .wrap -->
			</div><!-- .navigation-top -->
			<?php
     			if ( $disable_search_form == 0 ){
					/**
					* Search Form
					*/
					do_action('trustnews_frontend_search_form');

				} ?>

			<div class="main-header-brand">
				<?php if( ( has_nav_menu( 'menu-3' ) ) || (  has_nav_menu('menu-2') ) ) { ?>
					<div class="secondary-nav-wrap">
						<div class="wrap">
							<div class="clock">
								<div id="date"><?php echo date_i18n(__('l, F d, Y','trustnews')); ?></div>
							</div>
							<?php

							if( has_nav_menu( 'menu-3' ) ){
								/**
								 * Secondary Navigation
								 */
								do_action('trustnews_frontend_secondary_navigation');

							}

							if(has_nav_menu('menu-2')){ ?>
								<div class="header-social-menu">

									<?php
										/**
										 * Social navigation
										 */
										do_action ('trustnews_frontend_social_navigation');
									?>

								</div><!-- .header-social-menu -->
							<?php } ?>
						</div><!-- .wrap -->
					</div><!-- .secondary-nav-wrap -->
				<?php } ?>

				<div class="header-brand" <?php if (!empty($upload_header_brand)){ ?> style="background-image: url('<?php echo esc_url ($upload_header_brand); ?>');"<?php } ?>>
					<div class="wrap">
						<div class="header-brand-content">
							<?php 

								/**
								 * Site Branding
								 */
								do_action ('trustnews_frontend_site_branding');
							?>

							<div class="header-right">
								<div class="header-banner">

									<?php if ( is_active_sidebar( 'header-banner' ) ) {

										dynamic_sidebar( 'header-banner' );

									} ?>
								</div><!-- .header-banner -->
							</div><!-- .header-right -->
						</div><!-- .header-brand-content -->
					</div><!-- .wrap -->
				</div><!-- .header-brand -->

				<div id="nav-sticker">
					<div class="navigation-top">
						<div class="wrap">
							<div id="site-header-menu" class="site-header-menu">
								<nav id="site-navigation" class="main-navigation" aria-label="<?php esc_attr_e('Primary Menu','trustnews'); ?>">
								<?php

									/**
									 * Top Navigation
									 */
									do_action('trustnews_frontend_navigation_top');

								?>
								</nav><!-- #site-navigation -->
	            			<?php if($disable_search_form ==0) { ?>
									<button type="button" class="search-toggle"><span><span class="screen-reader-text"><?php esc_html_e('Search for:','trustnews'); ?></span></span></button>
								<?php } ?>
							</div>
        				</div><!-- .wrap -->
     				</div><!-- .navigation-top -->
     			</div><!-- #nav-sticker -->
     			<?php
     			if ( $disable_search_form == 0 ){
					/**
					* Search Form
					*/
					do_action('trustnews_frontend_search_form');

				}

				if ($disable_breaking_news ==0 ) { ?>
					<div class="breaking-news-holder">
						<div class="wrap">
							<div class="top-header">
								<div class="top-header-inner">
									<?php
										/**
										* Breaking News
										*/
										do_action('trustnews_frontend_breaking_news');
									?>
								</div><!-- .top-header-inner -->
							</div><!-- .top-header -->
						</div><!-- .wrap -->
					</div><!-- .breaking-news-holder -->
				<?php }
				?>
			</div><!-- .main-header-brand -->
			<?php do_action ('trustnews_frontend_main_banner_after_hook'); ?>
		</div><!-- .main-header -->
	</header><!-- #masthead -->

	<div id="content" class="site-content">
		<div class="site-content-cell">
			<?php 

				/**
				* Advertise second 
				*/
				do_action('trustnews_frontend_advertise_second');

			?>
			<div class="wrap wrap-width">
