<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package trio-lite
 */
?>

<!-- Featured Post -->
<article <?php post_class(); ?>>
	<header class="entry-header">
		<figure>
			<?php the_post_thumbnail('TRIO-category-post');?>										
		</figure>
		<div class="entry-meta">
			<span><?php _e('In', 'trio-lite'); ?>  <?php the_category( ' ' ); ?></span>
			<span>&#8226;</span>
			<span><?php _e('By', 'trio-lite'); ?> <?php the_author_posts_link(); ?> </span>
			<span>&#8226;</span>
			<span><i class="fa fa-calendar-o" aria-hidden="true"></i> <a href="<?php esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_date(); ?></a></span>
			<span>&#8226;</span>
			<?php if(get_comments_number() == 0){ ?>
				<a href="<?php comments_link(); ?>"><span><i class="fa fa-comment-o" aria-hidden="true"></i><?php _e('No Comments','trio-lite');?></span></a>
			<?php }else{ ?>
				<a href="<?php comments_link(); ?>"><span><i class="fa fa-comment-o" aria-hidden="true"></i> 
				<?php echo get_comments_number(); ?>&nbsp;<?php _e('Comments', 'trio-lite');?>
				</span></a>
			<?php }?>
		</div>
		<h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
	</header>
	<div class="entry-content">
		<p><?php the_excerpt() ;?></p>
	</div>
	<footer class="entry-footer">
		<ul class="list list--horizontal">
			<li><a href="<?php the_permalink();?>" class="button button--fill button--red"><?php _e('Continue Reading', 'trio-lite'); ?></a></li>
		</ul>
	</footer>
</article><!-- Featured Post -->