<?php
/**
 * Template part for displaying page content in page.php
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */
?>

<!-- Intro -->
				<div id="banner" class="site-banner">
					<article <?php post_class(); ?>>
						<header class="entry-header">
							<figure>
								<?php the_post_thumbnail('TRIO-category-detail');?>
								<figcaption><?php _e('Photography by','trio-lite');?> </figcaption>
							</figure>
							<div class="entry-meta">
								<?php the_category( ' ' ); ?>
								<span><?php _e('By', 'trio-lite'); ?> <?php the_author_posts_link(); ?> </span>
								<span>&#8226;</span>
								<span><i class="fa fa-calendar-o" aria-hidden="true"></i> <a href="<?php esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_date(); ?></a></span>
								<span>&#8226;</span>
								<span><i class="fa fa-comment-o" aria-hidden="true"></i> <?php get_comments_number(); ?></span>
							</div>
							<h2 class="entry-title"><?php the_title();?></h2>
						</header>
					</article>
				</div>

<!-- Featured Post -->
	<article <?php post_class(); ?>>
		<header class="entry-header">
			<h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
			<figure>
				<?php the_post_thumbnail('large');?>
			</figure>
			
		</header>
			<div class="entry-content">
				<p>
					<?php the_content() ;?>
				</p>
			</div>
			<div class="entry-paginated-link"><?php wp_link_pages(); ?></div>
		<footer class="entry-footer">
			<ul class="list list--horizontal">
				<li><a href="<?php the_permalink();?>" class="button button--fill button--red"><?php _e('Continue Reading', 'trio-lite'); ?></a></li>
			</ul>						
		</footer>					
	</article>