<?php
/**
 * The template for displaying all single posts(detail pages)
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 */

get_header();
?>
<?php while (have_posts()) : the_post(); ?>
<!-- Intro -->
<div id="banner" class="site-banner">
	<article <?php post_class(); ?>>
		<header class="entry-header">
			<figure>
				<?php the_post_thumbnail('TRIO-category-detail');?>
			</figure>
			<div class="entry-meta">
				<span><?php _e('In', 'trio-lite'); ?> <?php the_category( ' ' ); ?></span>
				<span>&#8226;</span>
				<span><?php _e('By', 'trio-lite'); ?> <?php the_author_posts_link(); ?> </span>
				<span>&#8226;</span>
				<span><i class="fa fa-calendar-o" aria-hidden="true"></i> <a href="<?php esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_date(); ?></a></span>
				<span>&#8226;</span>
				<?php if(get_comments_number() == 0){ ?>
				<span><i class="fa fa-comment-o" aria-hidden="true"></i> <?php _e('No Comments','trio-lite');?></span>
				<?php }else{ ?>
				<a href="<?php comments_link(); ?>"><span><i class="fa fa-comment-o" aria-hidden="true"></i> 
				<?php echo get_comments_number(); ?>&nbsp;<?php _e('Comments', 'trio-lite');?>
					</span></a>
				<?php }?>
			</div>
			<h2 class="entry-title"><?php the_title();?></h2>
		</header>
	</article>
</div>
<!-- Main -->
<main id="main" class="site-main">

	<!-- Featured Post -->
	<article <?php post_class(); ?>>
		<div class="entry-content">
			<?php the_content(); ?>
		</div>
		<div class="entry-paginated-link"><?php wp_link_pages(); ?></div>
	</article>

	<!-- Footer -->		
	<?php endwhile; ?>
	<footer>
		<nav class="pagination" role="navigation">
			<h2 class="screen-reader-text"><?php _e('Posts navigation','trio-lite');?></h2>
			<?php echo previous_post_link('%link','<i class="fa fa-long-arrow-left"></i> Previous post');?>
			<?php echo next_post_link('%link','Next post   <i class="fa fa-long-arrow-right"></i>');?>
		</nav>
	</footer>
	<div class="article">
	<?php if ( comments_open() || get_comments_number() ) :
				comments_template();
	endif;   ?>
	</div>
</main>			
<?php get_sidebar(); ?>
<?php get_footer(); ?>