<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 */
 ?>
<?php get_header();
$counter=0;
?>			
			<?php while (have_posts()) : the_post(); ?>
			<?php if($counter < 1): ?>
			<!-- Intro -->
			<div id="banner" class="site-banner">
				<article class="post">
					<header class="entry-header">
						<figure>
							<?php the_post_thumbnail('TRIO-category-thumb');?>                      		
						</figure>
						<div class="entry-meta">
							<span><?php _e('In', 'trio-lite'); ?> <?php the_category( ' ' ); ?></span>
							<span>&#8226;</span>
							<span><?php _e('By', 'trio-lite'); ?> <?php the_author_posts_link(); ?> </span>
							<span>&#8226;</span>
							<span><i class="fa fa-calendar-o" aria-hidden="true"></i> <a href="<?php esc_url(get_month_link(get_the_time('Y'), get_the_time('m'))); ?>"><?php the_date(); ?></a></span>
							<span>&#8226;</span>
							<?php if(get_comments_number() == 0){ ?>
								<a href="<?php comments_link(); ?>"><span><i class="fa fa-comment-o" aria-hidden="true"></i><?php _e('No Comments','trio-lite');?></span></a>
							<?php }else{ ?>
								<a href="<?php comments_link(); ?>"><span><i class="fa fa-comment-o" aria-hidden="true"></i> 
								<?php echo get_comments_number(); ?>&nbsp;<?php _e('Comments', 'trio-lite');?>
								</span></a>
							<?php }?>
							
						</div>
						<h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
					</header>
				</article>
			</div><!-- Intro -->

			<?php else:   if($counter ==1): echo '<main id="main" class="site-main">'; endif; ?>

				 	<?php get_template_part('template/content'); ?>		

			<?php endif; ?>
			<?php $counter++; endwhile; ?>
           <!--navigation-->
			<footer>
			   <nav class="pagination" role="navigation">
				  <h2 class="screen-reader-text"><?php _e('Posts navigation','trio-lite');?></h2>
					<?php the_posts_pagination( array(
						'mid_size' => 1,
						'prev_text' => __( '&larr; Previous', 'trio-lite' ),
						'next_text' => __( 'Next &rarr;', 'trio-lite' ),
					) );
					?>
				</nav>
			</footer>
		</main>
<?php get_sidebar(); ?>
<?php get_footer(); ?>						
