<?php 
/**
 * Theme set-up functions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 */

if ( ! function_exists( 'trio_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */

	function trio_setup(){
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on trio-lite, use a find and replace
		 * to change 'trio-lite' to the name of your theme in all the template files.
		 */
	    load_theme_textdomain( 'trio-lite' );

	    /*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

	    /*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );
	
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
	
		add_image_size( 'TRIO-category-thumb', 1500, 1000 );
	
		add_image_size( 'TRIO-category-post', 720, 480 );
	
		add_image_size( 'TRIO-category-detail', 1200, 800, true );
		
		add_theme_support( 'automatic-feed-links' );
		
		add_theme_support( 'post-formats', array( 'aside', 'gallery', 'audio' ) );
		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support( 'custom-logo', array(
			'height'      => 100,
			'width'       => 400,
			'flex-width' => true,
			'header-text' => array( 'site-title', 'site-description' ),
      	));
		
		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'trio_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );
	
		add_theme_support( 'custom-header', array(
			//'default-image'      => get_template_directory_uri() . 'img/default-image.jpg',
			'default-text-color' => '000',
			'width'              => 1000,
			'height'             => 250,
			'flex-width'         => true,
			'flex-height'        => true,
		));
	}
endif;
add_action('after_setup_theme', 'trio_setup');
/**
 * Enqueue scripts and styles.
 */
/***************/
## Attach stylesheets
/******************/
if ( ! function_exists ( 'trio_theme_scripts' ) ) {
	function trio_theme_scripts() {
		$trio_lite_font_url   = esc_url('https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700,800');
		wp_enqueue_style( 'TRIO-style', get_template_directory_uri() . '/assets/css/normalize.css', null, false, 'all');
		wp_enqueue_style( 'TRIO-font', get_template_directory_uri() . '/assets/css/font-awesome.min.css', null, false, 'all');
		wp_enqueue_style( 'TRIO-main-style', get_template_directory_uri() . '/assets/css/main.css', null, false, 'all');
		wp_enqueue_script('TRIO-main', get_template_directory_uri() . '/assets/js/main.js', array('jquery'), '1.0.0', true);
		wp_enqueue_style('TRIO-google_fonts',$trio_lite_font_url , null, false, 'all');
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
}
add_action( 'wp_enqueue_scripts', 'trio_theme_scripts' );
/***************/
## Excerpt filter
/******************/
if ( ! function_exists ( 'trio_custom_excerpt_length' ) ) {
	//Theme custom excerpt length
	function trio_custom_excerpt_length() {
		if ( is_admin() ) {
			return 20;
		}
		return esc_attr(get_theme_mod('trio_blog_excerpt_length', '20'));
	}
	add_filter('excerpt_length','trio_custom_excerpt_length');
}

//To trim the ... and [] in exert
if ( ! function_exists ( 'trio_trim_excerpt' ) ) {
	function trio_trim_excerpt($text) {
		if ( is_admin() ) {
			return $text;
		}
		return str_replace('[&hellip;]', '', $text);
	}			
	add_filter('excerpt_more','trio_trim_excerpt');
} 

/***************/
## body class
/******************/
if ( ! function_exists ( 'trio_body_class' ) ) {
	function trio_body_class($classes) {
		$classes[] = 'is-loading';	
	    return $classes;
	}
	add_filter('body_class', 'trio_body_class' );
}
/***************/
## post class
/******************/
if ( ! function_exists ( 'trio_post_class' ) ) {
	function trio_post_class($classes) {
		if(is_single()):
			$classes[] = 'post detailed';
		else:
			$classes[] = 'post featured';
		endif;
		return $classes;
	}
	add_filter('post_class', 'trio_post_class' );
}
/****************************************************/
## custom comments ping type call back function.
/****************************************************/
if ( ! function_exists ( 'trio_comment_list' ) ) {
	function trio_comment_list( $comment, $args, $depth ) {
	    switch ( $comment->comment_type ) :
	      case 'pingback' :  // 1
	      case 'trackback' : // 1
	    ?>
		<li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
		<p><?php _e( 'Pingback:', 'trio-lite' ); ?> <?php comment_author_link(); ?> <?php edit_comment_link( __( '(Edit)', 'trio-lite' ), '<span class="edit-link">', '</span>' ); ?></p>
	    <?php
	        break;
	      default : // 2
	      GLOBAL $post;
	      
	      $avatar_variation = ' img-thumbnail';
	    ?>
	    <li id="li-comment-<?php comment_ID(); ?>" <?php comment_class(); ?>>
	      <?php
		      printf( '<div class="comment-img">%1$s %2$s</div>',
		         get_avatar( $comment, 120 ),
		        ( $comment->user_id === $post->post_author ) ? '<span class="bypostauthor">' . __( 'Post<br>Author', 'trio-lite' ) . '</span>' : ''
		      );
	      ?>
	      <article id="comment-<?php comment_ID(); ?>" class="comment-meta">
	        <header class="comment-header">
	          <?php
	          printf( '<cite class="comment-author">%1$s</cite>',
	            get_comment_author_link()
	          );
	          printf( '<div> <a href="%1$s" class="comment-time"><time datetime="%2$s">%3$s</time></a> </div>',
	            esc_url( get_comment_link( $comment->comment_ID ) ),
	            get_comment_time( 'c' ),
	            sprintf( __( '%1$s at %2$s', 'trio-lite' ),
	              get_comment_date(),
	              get_comment_time()
	            )
	          );
	          edit_comment_link( __( '<i class="icon-edit"></i> Edit', 'trio-lite' ) );
	          ?>
			  <div class="comment-reply"><?php comment_reply_link( array_merge( $args, array( 'depth' => $depth, 'max_depth' => $args['max_depth'] ) ) ); ?></div><!-- .reply -->
	          
	        </header>
	        <?php if ( '0' == $comment->comment_approved ) : ?>
	          <p class="comment-awaiting-moderation"><?php _e( 'Your comment is awaiting moderation.', 'trio-lite' ); ?></p>
	        <?php endif; ?>
	        <section class="comment-content">
	          <?php comment_text(); ?>
	        </section>
	      </article>
	    <?php
	        break;
	    endswitch;
	}
}
?>