<?php
/***************/
## Options for WordPress Theme Customizer.
 /*****************/
/* Main option Settings Panel */
function trio_main_panel_customizer($wp_customize){
	//add panel for the main panel 
	$wp_customize->add_panel('main_panel', array(
		'capability' => 'edit_theme_options',
		'theme_supports' => '',
		'title' => __('Theme Options','trio-lite'),
		'description' => __('Panel to update Trio Lite theme options','trio-lite'),
		'priority' => 10		
	));
	$wp_customize->add_section('panel_setting', array(
		'title' => __('Layout Option','trio-lite'),
		'priority' => 30,
		'panel' => 'main_panel'
	));
	$wp_customize->add_setting('sidebar_setting', array(
		'default' => '2cr',
		'transport'   => 'refresh',
		'sanitize_callback' => 'trio_sanitize_sidebar_position'
	));
	$wp_customize->add_control('sidebar_setting', array(
		'label' => __('Sidebar Layout Options','trio-lite'),
		'section' => 'panel_setting',
		'type'    => 'select',
		'description' => __('Choose between different layout options to be used as default','trio-lite'),
		'choices'    => array(
			'1c' =>   __('No Sidebar', 'trio-lite'),
			'2cl' =>  __('Left Sidebar', 'trio-lite'),
			'2cr' =>  __('Right Sidebar', 'trio-lite')
		)
	));	
	/* color section setting */	
	$wp_customize->add_section('trio_color_settinges', array(
		'title'    => __('Theme Colors Section', 'trio-lite'),
		'description' => __('Theme primary color','trio-lite'),
		'panel' => 'main_panel',
		'priority' => 32,
	));
	$wp_customize->add_setting('trio_primary_color', array(
		'default' => '#bf9e3b',
		'transport'   => 'refresh',
		'sanitize_callback' => 'trio_sanitize_hexcolor'
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'trio_primary_color', array(
		'label' => __('Primary Color', 'trio-lite'), 
		'section' => 'trio_color_settinges',
	)));
	/* Theme Copyright text*/
	$wp_customize->add_section('trio_footer_content', array(
		'title'    => __('Footer Section', 'trio-lite'),
		'description' => __('Footer section content settings','trio-lite'),
		'panel' => 'main_panel',
		'priority' => 121,
	));	
	$wp_customize->add_setting( 'trio_copyright', array(
		'default' => '',
		'transport' => 'refresh', // or refresh
		'sanitize_callback' => 'trio_sanitize_strip_slashes'
	));
	$wp_customize->add_control( 'trio_copyright', array(
	  	'label'   => __( 'Copyright Text', 'trio-lite'),
	  	'type'    => 'textarea',
	  	'section' => 'trio_footer_content',
	));
}
add_action('customize_register', 'trio_main_panel_customizer' );
/**
 * Adds sanitization callback function: Strip Slashes
 * @package Trio Lite
 */
function trio_sanitize_strip_slashes($input) {
    return wp_kses_stripslashes($input);
}
/**
 * Adds sanitization callback function: Number
 * @package Trio Lite
 */
function trio_sanitize_number($input) {
    if ( isset( $input ) && is_numeric( $input ) ) {
        return $input;
    }
}
/**
 * Adds sanitization callback function: Sidebar Layout
 * @package Trio Lite
 */
function trio_sanitize_sidebar_position( $input ) {
   $site_layout = array(
		'1c' =>   __('No Sidebar', 'trio-lite'),
		'2cl' =>  __('Left Sidebar', 'trio-lite'),
		'2cr' =>  __('Right Sidebar', 'trio-lite')
	);
    if ( array_key_exists( $input, $site_layout ) ) {
        return $input;
    } else {
        return '';
    }
}
/**
 * Adds sanitization callback function: colors
 * @package Trio Lite
 */
function trio_sanitize_hexcolor($color) {
    if ($unhashed = sanitize_hex_color_no_hash($color))
        return '#' . $unhashed;
    return $color;
}
?>