<!DOCTYPE HTML>
<?php
$sidebar_setting = get_theme_mod('sidebar_setting', '2cr'); ?>
<html <?php language_attributes(); ?>>
	<head>	
		<meta charset="<?php bloginfo( 'charset' ); ?>">
		<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=no" />
		<?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
		<?php
			if (($sidebar_setting == '2cl' && (!is_page() && (!is_page_template('template/no-sidebar.php')))) || (is_page() && is_page_template('template/with-left-sidebar.php') )):
				echo  '<div id="wrapper" class="site-wrapper with-left-sidebar" style="">';
			elseif (($sidebar_setting == '2cr' && (!is_page() && (!is_page_template('template/no-sidebar.php')))) || (is_page() && is_page_template('template/with-right-sidebar.php') )):
			    echo '<div id="wrapper" class="site-wrapper with-right-sidebar" style="">';
			else :
			    echo '<div id="wrapper" class="site-wrapper with-no-sidebar" style="">';
			endif;
		?>
		<!-- Wrapper -->
		<div id="wrapperOverlay" class="site-wrapper__overlay"></div>
			<!-- Header -->
			<header id="header" style="background-image:url(<?php header_image(); ?>)">
				<div class="site-header">
				<div class="site-branding" style="color:#<?php echo esc_attr(get_theme_mod( 'header_textcolor' ));?>">
					<?php
						if (display_header_text() ==true ) {?>
			                <h1 class="site-title">
								<a href="<?php echo esc_url(home_url());?>"><?php echo bloginfo('name');?></a>
							</h1>
							<p class="site-description"><?php echo bloginfo( 'description' ); ?></p>                           
			        <?php  } else{ 
			            	the_custom_logo(); 
			         	}
					?>
				</div>
				
				<!-- Toggle -->
				<a href="javascript:void(0);" id="navToggle" class="site-toggle"><i class="fa fa-align-justify"></i></a>
				<!-- Nav -->
				<nav id="nav" class="site-navigation" role="navigation">
					<?php
						$menu=array(
							'container'=>'ul',	
							'menu_class'=>'links',
							'theme_location'=>'header_menu'	
						);
						wp_nav_menu( $menu);
					?>
				</nav>
				</div>
			</header>
			<button id="sidebarTrigger" class="site-sidebar__trigger"><?php _e('Sidebar','trio-lite');?> <i class="fa fa-plus"></i></button>