<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

/*
 * If the current post is protected by a password and
 * the visitor has not yet entered the password we will
 * return early without loading the comments.
 */
if ( post_password_required() ) {
	echo esc_html__( 'This post is password protected. Enter the password to view any comments.', 'trio-lite' );
	return;
}	
global $comments;
?>
<div id="comments" class="comments-area">

<?php
if ( have_comments() ) : ?>


	<h2 class="comments-title">
		 <?php /*Prints out the header that appears above the comments.*/
			 printf( _nx( '%1$s thought on "%2$s"', '%1$s thoughts on "%2$s"', get_comments_number(), 'comments title', 'trio-lite' ),
			 number_format_i18n( get_comments_number() ), '<span>' . get_the_title() . '</span>' ); ?>
	</h2>

	<ol class="comment">
			<?php /*The following snippet creates an ordered listing of comments using the wp_list_comments() function.*/
				wp_list_comments( array(
					'callback' => 'trio_comment_list',
					'style'      => 'ol',
					
				) );
			?>
	</ol><!-- .comment-list -->
			 <?php if ( get_comment_pages_count() > 1 ) : ?>
			   <?php previous_comments_link( __( '&larr; Older Comments', 'trio-lite' ) ); ?>
			   <?php next_comments_link( __('Newer Comments &rarr;', 'trio-lite' ) ); ?>
			 <?php endif; ?>

			<?php // If comments are closed and there are comments, let's leave a little note, shall we??>
			<?php if ( ! comments_open() ) : ?>
				<p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'trio-lite' ); ?></p>
			<?php endif; ?>
    <?php endif; // have_comments() ?>
<?php       
/******************************/
	     ## comment form section
                /******************************/
  comment_form( array(
    'comment_notes_after' => '',
    'id_submit'           => 'trio-comment-submit',
    'label_submit'        => __( 'Submit' , 'trio-lite' )
  ) );
 ?>
</div><!-- #comments -->