/*
	Trio Lite by ThemeBuffer
	themebuffer.com | @ThemeBuffer
	Free for personal and commercial use under the GPL 3.0 license (themebuffer.com/license)
*/

(function($) {

	/**
	 * Applies parallax scrolling to an element's background image.
	 * @return {jQuery} jQuery object.
	 */
	$(function() {

		var	$window = $(window),
			$body = $('body'),
			$wrapper = $('#wrapper'),
			$wrapperOverlay = $('#wrapperOverlay'),
			$header = $('#header'),
			$main = $('#main'),
			$nav = $('#nav'),
			$navToggle = $('#navToggle'),
			$sidebar = $('#sidebar'),
			$sidebarTrigger = $('#sidebarTrigger');

		// Disable animations/transitions until the page has loaded.
			$window.on('load', function() {
				window.setTimeout(function() {
					$body.removeClass('is-loading');
				}, 100);
			});
			
			$navToggle.on('click', function(){
				if(!$nav.hasClass('opened')){
					$nav.addClass('opened');
					$wrapper.addClass('nav--opened');
				}else{
					$nav.removeClass('opened');
					$wrapper.removeClass('nav--opened');
				}
			});
			
			$sidebarTrigger.on('click', function(){
				if(!$sidebar.hasClass('opened')){
					$sidebar.addClass('opened');
					$wrapper.addClass('sidebar--opened');
				}else{
					$sidebar.removeClass('opened');
					$wrapper.removeClass('sidebar--opened');
				}
			});

			$wrapperOverlay.on('click', function(event){
				if($nav.hasClass('opened')){$nav.removeClass('opened');}
				if($wrapper.hasClass('nav--opened')){$wrapper.removeClass('nav--opened');}
				
				if($sidebar.hasClass('opened')){$sidebar.removeClass('opened');}
				if($wrapper.hasClass('sidebar--opened')){$wrapper.removeClass('sidebar--opened');}
			});
	});

})(jQuery);






