<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 */

get_header(); ?>

<main id="main" class="site-main">
	
	<?php
		if ( have_posts() ) : ?>

			<header class="entry-header">
				<?php
					the_archive_title( '<h1 class="site-title">','</h1>' );
					the_archive_description( '<div class="site-description">','</div>' );
				?>
			</header><!-- .page-header -->

			<?php
			/* Start the Loop */
			while ( have_posts() ) : the_post();

				/*
				 * Include the Post-Format-specific template for the content.
				 * If you want to override this in a child theme, then include a file
				 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
				 */
				get_template_part( 'template/content');

			endwhile;

			the_posts_navigation();

		else :

			get_template_part( 'template/content', 'none' );

		endif; ?>
	
	 <!--navigation-->
			<footer>
			   <nav class="pagination" role="navigation">
				  <h2 class="screen-reader-text"><?php _e('Posts navigation','trio-lite');?></h2>
					<?php the_posts_pagination( array(
						'mid_size' => 2,
						'prev_text' => __( '&larr; Previous', 'trio-lite' ),
						'next_text' => __( 'Next &rarr;', 'trio-lite' ),
					) );
					?>
				</nav>
			</footer>
		</main><!-- #main -->

<?php
get_sidebar();
get_footer();
?>