<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 2.6.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $product, $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) )
	$woocommerce_loop['loop'] = 0;

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) )
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );

// Ensure visibility
if ( ! $product || ! $product->is_visible() )
	return;

// Extra post classes
$classes = array();
$classes[] = 'entry-item';
if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] )
	$classes[] = 'first';
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )
	$classes[] = 'last';
?>

<?php

$before_item = '<div class="kopa-row-30">';
$after_item = '</div>';

ob_start();

?>

<div class="match-height-item kopa-col mobile-fluid col-xs-6 col-md-3">
    <article itemtype="http://schema.org/Product" itemscope="" <?php post_class( $classes ); ?>>
        <div class="entry-thumb">
            <a href="<?php the_permalink(); ?>" itemprop="url" title="<?php the_title(); ?>">
                <?php echo woocommerce_get_product_thumbnail(); ?>
            </a>

            <?php if ( $product->is_on_sale() ) : ?>
                <span class="sale"><?php _e('sale!', 'trendmag-lite'); ?></span>
            <?php endif; ?>

            <a href="<?php echo esc_url( $product->add_to_cart_url() ); ?>" class="add-cart" title="<?php the_title(); ?>" data-product_id="<?php echo esc_attr( $product->id ); ?>" data-product_sku="<?php echo esc_attr( $product->get_sku() ); ?>" data-quantity="<?php echo esc_attr( isset( $quantity ) ? $quantity : 1 ); ?>"><i class="fa fa-shopping-cart"></i></a>

        </div>
        <div class="entry-content">

            <?php
            $product_terms = get_the_terms(  get_the_ID(), 'product_cat' );
            if ( $product_terms ) {
                $count = true;
                foreach ( $product_terms as $term ) {
                    if ( $count ) { ?>

                        <a href="<?php echo esc_url(get_term_link($term->term_id, 'product_cat')); ?>" class="product-categorie" title="<?php echo esc_html($term->name); ?>" rel="category"><?php echo esc_html($term->name); ?></a>

                        <?php
                    }
                    $count = false;
                }
            }

            if ( $rating_html = $product->get_rating_html() ) {
                echo wp_kses_post( $rating_html );
            }

            ?>

            <h4 class="product-name" itemprop="name"><a href="<?php the_permalink(); ?>" itemprop="url" title="<?php the_title(); ?>"><?php the_title(); ?></a></h4>
            <div class="clearfix"></div>

            <?php if ( $price_html = $product->get_price_html() ) : ?>
                <span class="price"><?php echo wp_kses_post( $price_html ); ?></span>
            <?php endif; ?>

        </div>
    </article>
    <!-- /.entry-item -->
</div>

<?php
$item_html = ob_get_clean();


if ($woocommerce_loop['loop'] % 4 == 0){
    echo wp_kses_post( $before_item );
}
echo wp_kses_post( $item_html );
if ($woocommerce_loop['loop'] % 4 == 3){
    echo wp_kses_post( $after_item );
}
$woocommerce_loop['loop']++;


