<?php
global $post;
$post_id = $post->ID;

$author_id = get_the_author_meta('ID');
$author_url = get_author_posts_url($author_id);
$author_name = get_the_author_meta('display_name');

$author_site = get_the_author_meta('url');
$author_desc = get_the_author_meta('description');

?>
<section class="wpi-section wpi-single-section single-author-panel">
    <div class="single-author-wrapper">
        <div class="entry-image image-hover-effect hover-effect-shine">
            <a href="<?php echo esc_url($author_url); ?>" title="<?php echo esc_attr(get_the_author()); ?>">
                <?php echo get_avatar(get_the_author_meta('ID'), 500); ?>
            </a>
        </div>
        <div class="entry-details">

            <?php do_action('trendingnews_author_detail_start'); ?>
            <h2>
                <a href="<?php echo esc_url($author_url); ?>" title="<?php echo esc_attr(get_the_author()); ?>"
                   class="author-name">
                    <?php the_author(); ?>
                </a>
            </h2>

            <?php if ($author_desc): ?>
                <div class="author-desc">
                    <?php echo wpautop($author_desc); ?>
                </div>
            <?php endif; ?>

            <?php if ($author_site): ?>
                <div class="author-url">
                    <a href="<?php echo esc_url($author_site); ?>" target="_blank">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="45px" height="56px" viewBox="0 0 45 56" version="1.1">
                                <path fill="currentColor" d="M 7.035156 23.078125 L 12.351562 23.078125 C 12.515625 27.765625 14.40625 32.214844 17.644531 35.589844 C 13.984375 34.769531 10.773438 32.515625 8.851562 29.214844 C 7.742188 27.308594 7.140625 25.203125 7.035156 23.078125 Z M 17.648438 9.253906 C 14.40625 12.628906 12.515625 17.078125 12.351562 21.765625 L 7.035156 21.765625 C 7.140625 19.640625 7.742188 17.535156 8.851562 15.628906 C 10.773438 12.328125 13.984375 10.074219 17.648438 9.253906 Z M 20.722656 7.523438 C 15.355469 7.523438 10.390625 10.363281 7.707031 14.972656 C 5.023438 19.582031 5.023438 25.261719 7.707031 29.871094 C 10.375 34.453125 14.777344 37.28125 20.710938 37.296875 C 26.644531 37.3125 32.824219 33.257812 34.90625 27.328125 L 33.488281 27.328125 C 31.832031 31.574219 28.144531 34.679688 23.71875 35.660156 C 26 33.332031 27.640625 30.464844 28.492188 27.328125 L 27.125 27.328125 C 26.15625 30.636719 24.121094 33.714844 21.464844 35.976562 C 21.4375 35.976562 21.410156 35.980469 21.382812 35.980469 L 21.382812 27.273438 L 20.058594 27.273438 L 20.058594 35.921875 C 20.007812 35.917969 19.953125 35.914062 19.902344 35.90625 C 16.109375 32.671875 13.859375 28.019531 13.675781 23.078125 L 16.6875 23.078125 L 16.128906 21.765625 L 13.675781 21.765625 C 13.859375 16.824219 16.109375 12.171875 19.898438 8.933594 C 19.953125 8.933594 20.003906 8.925781 20.058594 8.921875 L 20.058594 19.34375 L 21.382812 19.34375 L 21.382812 8.851562 C 21.441406 8.855469 21.5 8.859375 21.558594 8.863281 C 24.722656 11.550781 26.851562 15.277344 27.570312 19.34375 L 28.914062 19.34375 C 28.855469 19.015625 28.785156 18.644531 28.703125 18.28125 C 27.917969 14.859375 26.226562 11.710938 23.785156 9.1875 C 28.808594 10.332031 32.863281 14.207031 34.070312 19.34375 L 35.417969 19.34375 C 35.375 19.136719 35.34375 18.976562 35.289062 18.769531 C 33.601562 12.179688 27.613281 7.523438 20.722656 7.523438 Z M 20.722656 7.523438 "/>
                                <path fill="currentColor" d="M 17.75 20.664062 C 17.335938 20.699219 17.078125 21.121094 17.238281 21.503906 L 18.867188 25.574219 C 19.070312 26.09375 19.820312 26.089844 20.011719 25.5625 L 20.710938 23.714844 L 21.410156 25.5625 C 21.613281 26.082031 22.347656 26.089844 22.558594 25.574219 L 24.1875 21.503906 C 24.488281 20.75 23.347656 20.296875 23.046875 21.050781 L 22.003906 23.660156 L 21.289062 21.378906 C 21.085938 20.855469 20.34375 20.855469 20.136719 21.378906 L 19.421875 23.660156 L 18.378906 21.050781 C 18.28125 20.800781 18.027344 20.640625 17.75 20.664062 Z M 17.75 20.664062 "/>
                                <path fill="currentColor" d="M 25.59375 20.664062 C 25.179688 20.703125 24.925781 21.125 25.085938 21.503906 L 26.710938 25.574219 C 26.921875 26.089844 27.65625 26.082031 27.859375 25.5625 L 28.558594 23.722656 L 29.257812 25.5625 C 29.453125 26.089844 30.195312 26.09375 30.40625 25.574219 L 32.03125 21.503906 C 32.375 20.730469 31.175781 20.257812 30.890625 21.050781 L 29.851562 23.664062 L 29.132812 21.382812 C 28.933594 20.851562 28.179688 20.851562 27.984375 21.382812 L 27.265625 23.664062 L 26.222656 21.054688 C 26.128906 20.796875 25.871094 20.636719 25.59375 20.664062 Z M 25.59375 20.664062 "/>
                                <path fill="currentColor" d="M 33.449219 20.664062 C 33.035156 20.703125 32.78125 21.125 32.9375 21.503906 L 34.566406 25.574219 C 34.773438 26.09375 35.519531 26.089844 35.714844 25.5625 L 36.414062 23.722656 L 37.113281 25.5625 C 37.3125 26.082031 38.046875 26.089844 38.257812 25.574219 L 39.890625 21.503906 C 40.191406 20.75 39.046875 20.296875 38.742188 21.050781 L 37.703125 23.664062 L 36.988281 21.378906 C 36.789062 20.851562 36.035156 20.851562 35.835938 21.378906 L 35.125 23.660156 L 34.078125 21.054688 C 33.984375 20.796875 33.722656 20.636719 33.449219 20.664062 Z M 33.449219 20.664062 "/>
                        </svg>
                    </a>
                </div>
            <?php endif; ?>



            <?php do_action('trendingnews_author_detail_end'); ?>

        </div>
    </div>
</section>