<?php
$enable_metro_banner_section = trendingnews_get_option('enable_metro_banner_section');
if (!$enable_metro_banner_section) {
    return;
}

$metro_banner_category = trendingnews_get_option('metro_banner_category');
$metro_banner_layout = trendingnews_get_option('metro_banner_layout');
$metro_banner_category_offset = trendingnews_get_option('metro_banner_category_offset', 0);
$enable_metro_banner_author_meta = trendingnews_get_option('enable_metro_banner_author_meta');
$select_metro_banner_author_meta = trendingnews_get_option('select_metro_banner_author_meta');
$metro_banner_author_meta_title = trendingnews_get_option('metro_banner_author_meta_title');
$enable_metro_banner_date_meta = trendingnews_get_option('enable_metro_banner_date_meta');
$select_metro_banner_date = trendingnews_get_option('select_metro_banner_date');
$select_metro_banner_date_meta_title = trendingnews_get_option('select_metro_banner_date_meta_title');
$select_metro_banner_date_format = trendingnews_get_option('select_metro_banner_date_format');
$enable_metro_banner_category_meta = trendingnews_get_option('enable_metro_banner_category_meta');
$select_metro_banner_number_of_category = trendingnews_get_option('select_metro_banner_number_of_category');
$metro_banner_category_label = trendingnews_get_option('metro_banner_category_label');
$select_metro_banner_category_color = trendingnews_get_option('select_metro_banner_category_color');

if ($metro_banner_layout === 'metro-layout-1') {
    $number_of_posts = 5;
} elseif ($metro_banner_layout === 'metro-layout-2') {
    $number_of_posts = 6;
} else {
    $number_of_posts = 5;
}
$post_args = array(
    'post_type'           => 'post',
    'posts_per_page'      => absint($number_of_posts),
    'post_status'         => 'publish',
    'no_found_rows'       => 1,
    'ignore_sticky_posts' => 1,
    'offset'              => absint($metro_banner_category_offset),
);

// Check for category
if (!empty($metro_banner_category)) {
    $post_args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'field'    => 'term_id',
            'terms'    => $metro_banner_category,
        ),
    );
}

$metro_banner_query = new WP_Query($post_args);

if ($metro_banner_query->have_posts()) :
    ?>
    <section class="wpi-section wpi-metro-banner <?php echo esc_attr($metro_banner_layout); ?>">
        <div class="wrapper">
            <div class="metro-banner">
            <?php
            $post_count = 0;
            while ($metro_banner_query->have_posts()) :
                $metro_banner_query->the_post();
                $post_count++;
                $article_class = ($post_count === 1) ? 'wpi-metro-post metro-post-first' : 'wpi-metro-post metro-post-regular';
                $title_class   = ($post_count === 1) ? 'entry-title-large' : 'entry-title-medium';
                $thumb_size    = ($post_count === 1) ? 'full' : 'large';
                ?>
                <article id="metro-banner-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-tile-post wpi-post-metro ' . $article_class); ?>>
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="entry-image image-hover-effect hover-effect-shine <?php echo ($post_count === 1) ? 'entry-image-large' : 'entry-image-medium'; ?>">
                            <a class="post-thumbnail" href="<?php the_permalink(); ?>">
                                <?php
                                the_post_thumbnail(
                                    $thumb_size,
                                    array(
                                        'alt' => the_title_attribute(array('echo' => false)),
                                    )
                                );
                                ?>
                            </a>
                        </div>
                    <?php endif; ?>

                    <div class="entry-details">
                        <?php
                        if ($enable_metro_banner_category_meta) {
                            trendingnews_post_category(
                                $select_metro_banner_category_color,
                                $metro_banner_category_label,
                                $select_metro_banner_number_of_category
                            );
                        }
                        ?>
                        <h3 class="entry-title <?php echo esc_attr($title_class); ?>">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h3>

                        <div class="entry-meta-wrapper">
                            <?php
                            if ($enable_metro_banner_date_meta) {
                                trendingnews_posted_on(
                                    $select_metro_banner_date_format,
                                    $select_metro_banner_date_meta_title,
                                    $select_metro_banner_date
                                );
                            }
                            if ($enable_metro_banner_date_meta && $enable_metro_banner_author_meta) {
                                echo '<div class="entry-meta-separator"></div>';
                            }
                            if ($enable_metro_banner_author_meta) {
                                trendingnews_posted_by(
                                    $select_metro_banner_author_meta,
                                    $metro_banner_author_meta_title
                                );
                            }
                            ?>
                        </div>
                    </div>
                </article>
            <?php
            endwhile;
            wp_reset_postdata();
            ?>
        </div>
        </div>
    </section>
<?php
endif;
