<?php
$enable_dual_insights = trendingnews_get_option('enable_dual_insights');
if (!$enable_dual_insights) {
    return;
}
$dual_insights_title = trendingnews_get_option('dual_insights_title', 'Dual Insights');
$dual_inner_column_title = trendingnews_get_option('dual_inner_column_title', 'Trending');
$main_insights_category = trendingnews_get_option('main_insights_category');
$insights_post_1_offset = trendingnews_get_option('insights_post_1_offset');
$trending_insights_category = trendingnews_get_option('trending_insights_category');
$insights_post_2_offset = trendingnews_get_option('insights_post_2_offset');
$enable_insights_author_meta = trendingnews_get_option('enable_insights_author_meta');
$select_insights_author_meta = trendingnews_get_option('select_insights_author_meta');
$insights_author_meta_title = trendingnews_get_option('insights_author_meta_title');
$enable_insights_date_meta = trendingnews_get_option('enable_insights_date_meta');
$select_insights_date = trendingnews_get_option('select_insights_date');
$select_insights_date_meta_title = trendingnews_get_option('select_insights_date_meta_title');
$select_insights_date_format = trendingnews_get_option('select_insights_date_format');
$enable_insights_category_meta = trendingnews_get_option('enable_insights_category_meta');
$insights_category_label = trendingnews_get_option('insights_category_label');
$select_insights_category_color = trendingnews_get_option('select_insights_category_color');
$select_insights_number_of_category = trendingnews_get_option('select_insights_number_of_category');
if ($insights_post_1_offset) {
    $insights_post_1 = $insights_post_1_offset;
} else {
    $insights_post_1 = '';
}
// Query for main insights
$main_insights_args = array(
    'post_type' => 'post',
    'posts_per_page' => 5,
    'offset' => $insights_post_1,
    'post_status' => 'publish',
    'no_found_rows' => 1,
    'ignore_sticky_posts' => 1,
);
if (!empty($main_insights_category)) {
    $main_insights_args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'field' => 'term_id',
            'terms' => $main_insights_category,
        ),
    );
}
$main_insights = new WP_Query($main_insights_args);
if ($insights_post_2_offset) {
    $insights_post_2 = $insights_post_2_offset;
} else {
    $insights_post_2 = '';
}
// Query for trending insights
$trending_insights_args = array(
    'post_type' => 'post',
    'posts_per_page' => 6,
    'post_status' => 'publish',
    'offset' => $insights_post_2,
    'no_found_rows' => 1,
    'ignore_sticky_posts' => 1,
);
if (!empty($trending_insights_category)) {
    $trending_insights_args['tax_query'] = array(
        array(
            'taxonomy' => 'category',
            'field' => 'term_id',
            'terms' => $trending_insights_category,
        ),
    );
}
$trending_insights = new WP_Query($trending_insights_args);
if ($main_insights->have_posts() || $trending_insights->have_posts()) :
    ?>
    <section class="wpi-section wpi-dual-insights">
    <?php if ($dual_insights_title) { ?>
        <header class="section-header default-section-header">
            <div class="wrapper">
                <h2 class="section-title">
                    <?php echo esc_html($dual_insights_title); ?>
                </h2>
            </div>
        </header>
    <?php } ?>
        <div class="section-body">
            <div class="wrapper">
                <div class="row-group">
                    <div class="column-lg-7">
                        <div class="dual-insights-left">

                                <?php
                                $counter = 1;
                                if ($main_insights->have_posts()) :
                                    $delay = 600; // Initialize delay
                                    while ($main_insights->have_posts()) : $main_insights->the_post();
                                        ?>

                                        <?php if ($counter == 1) { ?>

                                            <article id="main-insight-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-list wpi-post-prime'); ?>>
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <div class="entry-image entry-image-big image-hover-effect hover-effect-shine">
                                                        <a class="post-thumbnail"
                                                           href="<?php the_permalink(); ?>" aria-hidden="true"
                                                           tabindex="-1">
                                                            <?php the_post_thumbnail('medium_large', array('alt' => the_title_attribute(array('echo' => false)))); ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="entry-details">
                                                    <?php
                                                    if ($enable_insights_category_meta) {
                                                        trendingnews_post_category($select_insights_category_color, $insights_category_label, $select_insights_number_of_category);
                                                    }
                                                    ?>
                                                    <h3 class="entry-title entry-title-big">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>
                                                    <div class="entry-meta-wrapper">
                                                        <?php
                                                        if ($enable_insights_date_meta) {
                                                            trendingnews_posted_on($select_insights_date_format, $select_insights_date_meta_title, $select_insights_date);
                                                        }
                                                        if ($enable_insights_date_meta && $enable_insights_author_meta) {
                                                            echo '<div class="entry-meta-separator"></div>';
                                                        }
                                                        if ($enable_insights_author_meta) {
                                                            trendingnews_posted_by($select_insights_author_meta, $insights_author_meta_title);
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </article>

                                        <div class="row-group">
                                        <?php } else { ?>
                                        <div class="column-lg-6 column-md-6 mb-3">
                                            <article id="main-insight-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-default'); ?> data-aos="fade-up" data-aos-duration="2000" data-aos-delay="<?php echo esc_attr($delay); ?>">
                                                <?php if (has_post_thumbnail()) : ?>
                                                    <div class="entry-image entry-image-medium image-hover-effect hover-effect-shine">
                                                        <a class="post-thumbnail"
                                                           href="<?php the_permalink(); ?>" aria-hidden="true"
                                                           tabindex="-1">
                                                            <?php the_post_thumbnail('medium_large', array('alt' => the_title_attribute(array('echo' => false)))); ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="entry-details">
                                                    <?php
                                                    if ($enable_insights_category_meta) {
                                                        trendingnews_post_category($select_insights_category_color, $insights_category_label, $select_insights_number_of_category);
                                                    }
                                                    ?>
                                                    <h3 class="entry-title <?php echo $counter <= 3 ? 'entry-title-medium' : 'entry-title-small'; ?>">
                                                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                    </h3>
                                                    <div class="entry-meta-wrapper">
                                                        <?php
                                                        if ($enable_insights_date_meta) {
                                                            trendingnews_posted_on($select_insights_date_format, $select_insights_date_meta_title, $select_insights_date);
                                                        }
                                                        if ($enable_insights_date_meta && $enable_insights_author_meta) {
                                                            echo '<div class="entry-meta-separator"></div>';
                                                        }
                                                        if ($enable_insights_author_meta) {
                                                            trendingnews_posted_by($select_insights_author_meta, $insights_author_meta_title);
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </article>
                                        </div>
                                        <?php } ?>
                                        <?php if ($main_insights->current_post + 1 == $main_insights->post_count) { ?>
                                            </div> <!-- Close row-group -->
                                        <?php } ?>
                                    <?php
                                    $counter++;
                                    $delay += 100; // Increment delay for next post
                                    endwhile;
                                    wp_reset_postdata();
                                endif;
                                ?>

                        </div>
                    </div>
                    <div class="column-lg-5">
                        <div class="dual-insights-right">
                            <?php if (!empty($dual_inner_column_title)) : ?>
                                <header class="section-header header-has-style">
                                    <h2 class="section-title"><?php echo esc_html($dual_inner_column_title); ?></h2>
                                </header>
                            <?php endif; ?>
                            <div class="insights-column-body">
                                <?php
                                if ($trending_insights->have_posts()) :
                                    $list_delay = 100; // Initialize delay
                                    $trend_counter = 1; // Initialize counter
                                    while ($trending_insights->have_posts()) : $trending_insights->the_post();
                                        ?>
                                        <article id="trending-insight-<?php the_ID(); ?>" <?php post_class('wpi-post wpi-post-list post-has-padding'); ?> data-aos="fade-left" data-aos-duration="1000" data-aos-delay="<?php echo esc_attr($list_delay); ?>">
                                            <div class="entry-counter">
                                                <span><?php echo $trend_counter; ?></span>
                                            </div>
                                            <div class="entry-details">
                                                <?php
                                                if ($enable_insights_category_meta) {
                                                    trendingnews_post_category($select_insights_category_color, $insights_category_label, $select_insights_number_of_category);
                                                }
                                                ?>
                                                <h3 class="entry-title entry-title-small">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h3>
                                                <div class="entry-meta-wrapper">
                                                    <?php
                                                    if ($enable_insights_date_meta) {
                                                        trendingnews_posted_on($select_insights_date_format, $select_insights_date_meta_title, $select_insights_date);
                                                    }
                                                    if ($enable_insights_date_meta && $enable_insights_author_meta) {
                                                        echo '<div class="entry-meta-separator"></div>';
                                                    }
                                                    if ($enable_insights_author_meta) {
                                                        trendingnews_posted_by($select_insights_author_meta, $insights_author_meta_title);
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                            <?php if (has_post_thumbnail()) : ?>
                                                <div class="entry-image entry-image-thumbnail image-hover-effect hover-effect-shine">
                                                    <a class="post-thumbnail" href="<?php the_permalink(); ?>"
                                                       aria-hidden="true" tabindex="-1">
                                                        <?php the_post_thumbnail('medium', array('alt' => the_title_attribute(array('echo' => false)))); ?>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                        </article>
                                    <?php
                                        $list_delay += 100; // Increment delay for next post
                                        $trend_counter++; // Increment counter for next post
                                    endwhile;
                                    wp_reset_postdata();
                                endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php
endif;
?>