<?php
/**
 * Displays footer navigation
 *
 * @package TrendingNews
 */
$enable_footer_nav = trendingnews_get_option('enable_footer_nav');

$enable_footer_social_nav = trendingnews_get_option('enable_footer_social_nav');
$enable_footer_social_nav_border_radius = trendingnews_get_option('enable_footer_social_nav_border_radius');
$select_footer_social_menu_style = trendingnews_get_option('select_footer_social_menu_style');

?>
<?php if ($enable_footer_nav) { ?>
    <div class="site-footer-area site-footer-navigation">
        <div class="wrapper">
            <div class="row-group">

                <div class="column-sm-12 column-md-4">
                    <?php if ($enable_footer_social_nav) { ?>
                        <nav class="footer-social-navigation" aria-label="<?php esc_attr_e('Footer Social links', 'trendingnews'); ?>">
                            <ul class="social-menu reset-list-style social-icons <?php echo esc_attr($select_footer_social_menu_style); ?> <?php if ($enable_footer_social_nav_border_radius) {
                                echo "has-border-radius";
                            } ?>">
                                <?php
                                wp_nav_menu(
                                    array(
                                        'theme_location' => 'social',
                                        'container' => '',
                                        'container_class' => '',
                                        'items_wrap' => '%3$s',
                                        'menu_id' => '',
                                        'menu_class' => '',
                                        'depth' => 1,
                                        'link_before' => '<span class="screen-reader-text">',
                                        'link_after' => '</span>',
                                        'fallback_cb' => '',
                                    )
                                );
                                ?>
                            </ul>
                        </nav>
                    <?php } ?>
                </div>
                <div class="column-sm-12 column-md-6">

                    <?php
                    echo '<h2 class="wp-block-heading">' . esc_html__('Links', 'trendingnews') . '</h2>';
                    wp_nav_menu(array(
                        'theme_location'  => 'footer',
                        'container_class' => 'footer-navigation',
                        'fallback_cb'     => false,
                        'depth'           => 1,
                        'menu_class'      => 'footer-menu reset-list-style',
                    ));
                    ?>

                </div>
            </div>
        </div>
    </div>
<?php } ?>