<?php
if (!defined('ABSPATH')) {
    exit;
}
class TrendingNews_Slider_Posts extends TrendingNews_Widget_Base
{
    public function __construct()
    {
        $this->widget_cssclass = 'trendingnews-slider-widget';
        $this->widget_description = __("Displays recent posts in a slider with an image", 'trendingnews');
        $this->widget_id = 'trendingnews_slider_posts';
        $this->widget_name = __('TrendingNews: Slider Posts', 'trendingnews');
        $this->settings = $this->get_widget_settings();
        parent::__construct();
    }
    /**
     * Define widget settings.
     */
    protected function get_widget_settings()
    {
        return array(
            'title' => array(
                'type' => 'text',
                'label' => __('Title', 'trendingnews'),
                'std' => __('Slider Posts', 'trendingnews'),
            ),
            'display_layout' => array(
                'type' => 'select',
                'label' => __('Display Layout', 'trendingnews'),
                'options' => array(
                    'display-regular-layout' => __('Wrapper Layout', 'trendingnews'),
                    'display-fullwidth-layout' => __('Full Width Layout', 'trendingnews'),
                ),
                'std' => 'display-regular-layout',
                'desc' => __('Works exclusively in the fullwidth widget area', 'trendingnews'),
            ),
            'vertical_alignment' => array(
                'type' => 'select',
                'label' => __('Vertical Alignment', 'trendingnews'),
                'options' => array(
                    'vertical-align-top' => __('Top', 'trendingnews'),
                    'vertical-align-middle' => __('Middle', 'trendingnews'),
                    'vertical-align-bottom' => __('Bottom', 'trendingnews'),
                ),
                'std' => 'vertical-align-middle',
            ),
            'text_alignment' => array(
                'type' => 'select',
                'label' => __('Text Alignment', 'trendingnews'),
                'options' => array(
                    'align-text-center' => __('Center', 'trendingnews'),
                    'align-text-left' => __('Left', 'trendingnews'),
                    'align-text-right' => __('Right', 'trendingnews'),
                ),
                'std' => 'align-text-center',
            ),
            'display_style' => array(
                'type' => 'select',
                'label' => __('Display Style', 'trendingnews'),
                'options' => array(
                    'wpi-post-regular' => __('Regular View', 'trendingnews'),
                    'wpi-slides-card' => __('Card View', 'trendingnews'),
                ),
                'std' => 'wpi-post-regular',
            ),
            'category' => array(
                'type' => 'dropdown-taxonomies',
                'label' => __('Select Category', 'trendingnews'),
                'args' => array(
                    'taxonomy' => 'category',
                    'class' => 'widefat',
                    'hierarchical' => true,
                    'show_count' => 1,
                    'show_option_all' => __('&mdash; Select &mdash;', 'trendingnews'),
                ),
            ),

            'number' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 1,
                'std' => 5,
                'label' => __('Number of posts to show', 'trendingnews'),
            ),
            'offset' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 0,
                'max' => '',
                'std' => 0,
                'label' => __('Offset', 'trendingnews'),
                'desc' => __('Offsets are used to skip a certain number of WordPress posts before starting output. Set it to 0 if you do not wish to use this feature.', 'trendingnews'),
            ),
            'show_excerpt' => array(
                'type' => 'checkbox',
                'label' => __('Enable Excerpt', 'trendingnews'),
                'std' => false,
            ),
            'font_size' => array(
                'type' => 'select',
                'label' => __('Entry title font size', 'trendingnews'),
                'options' => array(
                    'entry-title-small' => __('Small', 'trendingnews'),
                    'entry-title-medium' => __('Medium', 'trendingnews'),
                    'entry-title-big' => __('Big', 'trendingnews'),
                    'entry-title-large' => __('Large', 'trendingnews'),
                ),
                'std' => 'entry-title-large',
            ),
            'font_style' => array(
                'type' => 'select',
                'label' => __('Entry title font style', 'trendingnews'),
                'options' => array(
                    'entry-title-normal' => __('Normal', 'trendingnews'),
                    'entry-title-italic' => __('Italic', 'trendingnews'),
                ),
                'std' => 'entry-title-normal',
            ),
            'image_size' => array(
                'type' => 'select',
                'label' => __('Image size', 'trendingnews'),
                'options' => array(
                    'medium' => __('Medium', 'trendingnews'),
                    'medium_large' => __('Medium Large', 'trendingnews'),
                    'large' => __('Large', 'trendingnews'),
                    'full' => __('Full', 'trendingnews'),
                ),
                'std' => 'large',
            ),
            'image_hover_effects' => array(
                'type' => 'select',
                'label' => __('Image hover effects', 'trendingnews'),
                'options' => array(
                    'hover-effect-shine' => __('Shine', 'trendingnews'),
                    'hover-effect-slide' => __('Slide', 'trendingnews'),
                    'hover-effect-zoom' => __('Zoom', 'trendingnews'),
                ),
                'std' => 'hover-effect-shine',
            ),
            'show_overlay' => array(
                'type' => 'checkbox',
                'label' => __('Enable background overlay', 'trendingnews'),
                'std' => true,
            ),
            'image_overlay_style' => array(
                'type' => 'select',
                'label' => __('Background overlay style', 'trendingnews'),
                'options' => array(
                    'regular' => __('Regular', 'trendingnews'),
                    'gradient' => __('Gradient', 'trendingnews'),
                ),
                'std' => 'gradient',
            ),
            'height' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 150,
                'max' => '',
                'std' => 640,
                'label' => __('Height (px)', 'trendingnews'),
                'desc' => __('Change Height of Slides.', 'trendingnews'),
            ),
            'arrows' => array(
                'type' => 'checkbox',
                'label' => __('Enable Arrows', 'trendingnews'),
                'std' => true,
            ),
            'dots' => array(
                'type' => 'checkbox',
                'label' => __('Enable Dots', 'trendingnews'),
                'std' => false,
            ),
            'autoplay' => array(
                'type' => 'checkbox',
                'label' => __('Autoplay', 'trendingnews'),
                'std' => true,
            ),
            'orderby' => array(
                'type' => 'select',
                'std' => 'date',
                'label' => __('Order by', 'trendingnews'),
                'options' => array(
                    'date' => __('Date', 'trendingnews'),
                    'ID' => __('ID', 'trendingnews'),
                    'title' => __('Title', 'trendingnews'),
                    'rand' => __('Random', 'trendingnews'),
                ),
            ),
            'order' => array(
                'type' => 'select',
                'std' => 'desc',
                'label' => __('Order', 'trendingnews'),
                'options' => array(
                    'asc' => __('ASC', 'trendingnews'),
                    'desc' => __('DESC', 'trendingnews'),
                ),
            ),
            'show_date' => array(
                'type' => 'checkbox',
                'label' => __('Show Date', 'trendingnews'),
                'std' => true,
            ),
            'date_format' => array(
                'type' => 'select',
                'label' => __('Date Format', 'trendingnews'),
                'options' => array(
                    'classic'   => __( 'Classic', 'trendingnews' ),
                    'time_ago' => __( 'Time Ago', 'trendingnews' ),
                ),
                'std' => 'classic',
            ),
            'show_author' => array(
                'type' => 'checkbox',
                'label' => __('Show Author', 'trendingnews'),
                'std' => true,
            ),
            'display_author_option' => array(
                'type' => 'select',
                'label' => __('Author Option', 'trendingnews'),
                'options' => array(
                    'with_label' => __('With Label', 'trendingnews'),
                    'with_icon' => __('With Icon', 'trendingnews'),
                    'with_avatar_image' => __('With Avatar Image', 'trendingnews'),
                ),
                'std' => 'with_icon',
            ),
            'author_text' => array(
                'type' => 'text',
                'label' => __('Author Text', 'trendingnews'),
                'std' => __('By:', 'trendingnews'),
                'desc' => __('This only works when the "With Label" option is selected under "Author Option"', 'trendingnews'),
            ),
            'show_category' => array(
                'type' => 'checkbox',
                'label' => __('Show Category', 'trendingnews'),
                'std' => true,
            ),
            'category_text' => array(
                'type' => 'text',
                'label' => __('Category Text', 'trendingnews'),
            ),
            'display_category_option' => array(
                'type' => 'select',
                'label' => __('Category Option', 'trendingnews'),
                'options' => array(
                    'none' => __('None', 'trendingnews'),
                    'has-background' => __('Has background', 'trendingnews'),
                    'has-text-color' => __('Has text color', 'trendingnews'),
                ),
                'std' => 'has-background',
            ),
            'number_of_cat' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 1,
                'std' => 1,
                'label' => __('Number of Category to show', 'trendingnews'),
            ),
        );
    }
    /**
     * Query the posts and return them.
     */
    protected function get_posts($args, $instance)
    {
        $query_args = array(
            'posts_per_page' => !empty($instance['number']) ? absint($instance['number']) : $this->settings['number']['std'],
            'post_status' => 'publish',
            'no_found_rows' => 1,
            'orderby' => !empty($instance['orderby']) ? sanitize_text_field($instance['orderby']) : $this->settings['orderby']['std'],
            'order' => !empty($instance['order']) ? sanitize_text_field($instance['order']) : $this->settings['order']['std'],
            'offset' => !empty($instance['offset']) ? sanitize_text_field($instance['offset']) : $this->settings['offset']['std'],
            'ignore_sticky_posts' => 1
        );
       $query_args['offset'] = isset($instance['offset']) ? absint($instance['offset']) : 0;
        if (!empty($instance['category']) && -1 != $instance['category'] && 0 != $instance['category']) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => absint($instance['category']),
            );
        }
        return new WP_Query(apply_filters('trendingnews_slider_posts_query_args', $query_args));
    }
    /**
     * Output widget content.
     */
    public function widget($args, $instance)
    {
        $posts = $this->get_posts($args, $instance);
        if (!$posts->have_posts()) {
            return;
        }
        echo $args['before_widget'];
        do_action('trendingnews_before_slider_posts_with_image');
        $class = isset($instance['display_layout']) ? $instance['display_layout'] : $this->settings['display_layout']['std'];
        $vertical_alignment = !empty($instance['vertical_alignment']) ? $instance['vertical_alignment'] : $this->settings['vertical_alignment']['std'];
        if ($vertical_alignment) {
            $class .= ' ' . $vertical_alignment;
        }
        $slider_nav = '';
        $data_slider = array();
        $autoplay = isset($instance['autoplay']) ? $instance['autoplay'] : $this->settings['autoplay']['std'];
        if ($autoplay) :
            $data_slider['autoplay'] = array(
                'delay' => 4000,
            );
        endif;
        $dots = isset($instance['dots']) ? $instance['dots'] : $this->settings['dots']['std'];
        if ($dots) {
            $slider_nav .= '<div class="swiper-pagination wpi-swiper-pagination wpi-widget-pagination"></div>';
        }
        $arrows = isset($instance['arrows']) ? $instance['arrows'] : $this->settings['arrows']['std'];
        if ($arrows) {
            $slider_nav .= '<div class="widget-slider-next swiper-button-next"></div><div class="widget-slider-prev swiper-button-prev"></div>';
        }
        $widget_title = !empty($instance['title']) ? $instance['title'] : $this->settings['title']['std'];
        $words = explode(' ', $widget_title, 2);
        ?>
        <div class="wpi-slider-widget <?php echo esc_attr($class); ?>">
            <header class="section-header default-section-header section-header-center">
                <h2 class="section-title">
                    <span class="title-first-word" data-first-word="<?php echo esc_attr($words[0]); ?>">
                        <?php echo esc_html($words[0]); ?>
                    </span>
                    <?php echo isset($words[1]) ? ' ' . esc_html($words[1]) : ''; ?>
                </h2>
            </header>
            <div class="swiper wpi-swiper-init" data-slider='<?php echo esc_attr(json_encode($data_slider)); ?>'>
                <div class="swiper-wrapper">
                    <?php
                    while ($posts->have_posts()) : $posts->the_post();
                        $this->render_post($instance);
                    endwhile;
                    wp_reset_postdata();
                    ?>
                </div>
                <?php
                if ($slider_nav) :
                    echo $slider_nav;
                endif;
                ?>
            </div>
        </div>
        <?php
        do_action('trendingnews_after_slider_posts_with_image');
        echo $args['after_widget'];
    }
    /**
     * Render a single post item.
     */
    protected function render_post($instance)
    {
        $style = '';
        $display_style = !empty($instance['display_style']) ? $instance['display_style'] : $this->settings['display_style']['std'];
        $image_size = !empty($instance['image_size']) ? $instance['image_size'] : $this->settings['image_size']['std'];
        $image_hover_effects = !empty($instance['image_hover_effects']) ? $instance['image_hover_effects'] : $this->settings['image_hover_effects']['std'];
        $show_overlay = !empty($instance['show_overlay']) ? $instance['show_overlay'] : $this->settings['show_overlay']['std'];
        $image_overlay_style = !empty($instance['image_overlay_style']) ? $instance['image_overlay_style'] : $this->settings['image_overlay_style']['std'];
        $text_alignment = !empty($instance['text_alignment']) ? $instance['text_alignment'] : $this->settings['text_alignment']['std'];
        $font_size = !empty($instance['font_size']) ? $instance['font_size'] : $this->settings['font_size']['std'];
        $font_style = !empty($instance['font_style']) ? $instance['font_style'] : $this->settings['font_style']['std'];
        $height = isset($instance['height']) ? $instance['height'] : $this->settings['height']['std'];
        $style = 'height:' . esc_attr($height) . 'px;';
        $show_author = !empty($instance['show_author']) ? $instance['show_author'] : $this->settings['show_author']['std'];
        $author_text = !empty($instance['author_text']) ? $instance['author_text'] : $this->settings['author_text']['std'];
        $display_author_option = !empty($instance['display_author_option']) ? $instance['display_author_option'] : $this->settings['display_author_option']['std'];
        $category_text = !empty($instance['category_text']) ? $instance['category_text'] : '';
        $display_category_option = !empty($instance['display_category_option']) ? $instance['display_category_option'] : $this->settings['display_category_option']['std'];
        $number_of_cat = !empty($instance['number_of_cat']) ? absint($instance['number_of_cat']) : $this->settings['number_of_cat']['std'];
        $show_excerpt = !empty($instance['show_excerpt']) ? $instance['show_excerpt'] : $this->settings['show_excerpt']['std'];

        ?>
        <div class="swiper-slide wpi-swiper-slide">
            <article id="widget-slide-<?php the_ID(); ?>" <?php post_class('wpi-post ' . esc_attr($display_style)); ?>>
                <?php if (has_post_thumbnail()) : ?>
                    <div class="entry-image image-hover-effect <?php echo $image_hover_effects; ?> <?php if ($show_overlay) {
                        echo "entry-image-overlay";
                    } ?> image-overlay-<?php echo $image_overlay_style; ?>">
                        <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                            <?php
                            the_post_thumbnail(
                                $image_size,
                                array(
                                    'alt' => the_title_attribute(
                                        array(
                                            'echo' => false,
                                        )
                                    ),
                                    'style' => esc_attr($style)
                                )
                            );
                            ?>
                        </a>
                    </div>
                <?php endif; ?>
                <div class="entry-details <?php echo $text_alignment; ?>">
                    <div class="widget-wrapper">
                        <?php
                        if (!empty($instance['show_category']) && $instance['show_category']) {
                            trendingnews_post_category($display_category_option, $category_text, $number_of_cat);
                        }
                        ?>
                        <header class="entry-header">
                            <?php the_title('<h3 class="entry-title ' . $font_size . ' ' . $font_style . '"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                        </header>
                        <div class="entry-meta-wrapper">
                            <?php if (!empty($instance['show_date']) && $instance['show_date']) : ?>
                                <div class="entry-meta entry-date posted-on">
                                    <span class="screen-reader-text"><?php _e('Post Date', 'trendingnews'); ?></span>
                                    <?php trendingnews_the_theme_svg('calendar'); ?>
                                    <?php
                                    $date_format = !empty($instance['date_format']) ? $instance['date_format'] : 'classic';
                                        trendingnews_posted_on($date_format);
                                    ?>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($instance['show_author']) && $instance['show_author']) : ?>

                                    <?php
                                    if ($show_author) {
                                        trendingnews_posted_by($display_author_option, $author_text);
                                    }
                                    ?>

                            <?php endif; ?>
                        </div>
                        <?php if ($show_excerpt) { ?>
                            <div class="entry-summary">
                                <?php
                                trendingnews_the_archive_excerpt();
                                trendingnews_the_archive_readmore();
                                ?>
                            </div><!-- .entry-summary -->
                        <?php } ?>
                    </div>
                </div>
            </article>
        </div>
        <?php
    }
}