<?php
if (!defined('ABSPATH')) {
    exit;
}

class TrendingNews_Recent_Posts extends TrendingNews_Widget_Base
{
    public function __construct()
    {
        $this->widget_cssclass = 'trendingnews-recent-widget';
        $this->widget_description = __("Displays recent posts with an image", 'trendingnews');
        $this->widget_id = 'trendingnews_recent_posts';
        $this->widget_name = __('TrendingNews: Recent Posts', 'trendingnews');
        $this->settings = $this->get_widget_settings();
        parent::__construct();
    }

    /**
     * Define widget settings.
     */
    protected function get_widget_settings()
    {
        return array(
            'title' => array(
                'type' => 'text',
                'label' => __('Title', 'trendingnews'),
                'std' => __('Recent Posts', 'trendingnews'),
            ),
            'style' => array(
                'type' => 'select',
                'label' => __('Display Style', 'trendingnews'),
                'options' => array(
                    'wpi-post-regular' => __('Regular View', 'trendingnews'),
                    'wpi-post-list' => __('List View', 'trendingnews'),
                    'wpi-post-card' => __('Card View', 'trendingnews'),
                ),
                'std' => 'wpi-post-list',
            ),
            'font_size' => array(
                'type' => 'select',
                'label' => __('Entry title font size', 'trendingnews'),
                'options' => array(
                    'entry-title-small' => __('Small', 'trendingnews'),
                    'entry-title-medium' => __('Medium', 'trendingnews'),
                    'entry-title-big' => __('Big', 'trendingnews'),
                ),
                'std' => 'entry-title-small',
            ),
            'font_style' => array(
                'type' => 'select',
                'label' => __('Entry title font style', 'trendingnews'),
                'options' => array(
                    'entry-title-normal' => __('Normal', 'trendingnews'),
                    'entry-title-italic' => __('Italic', 'trendingnews'),
                ),
                'std' => 'entry-title-normal',
            ),
            'category' => array(
                'type' => 'dropdown-taxonomies',
                'label' => __('Select Category', 'trendingnews'),
                'args' => array(
                    'taxonomy' => 'category',
                    'class' => 'widefat',
                    'hierarchical' => true,
                    'show_count' => 1,
                    'show_option_all' => __('&mdash; Select &mdash;', 'trendingnews'),
                ),
            ),
            'number' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 1,
                'std' => 5,
                'label' => __('Number of posts to show', 'trendingnews'),
            ),
            'offset'                  => array(
                'type'  => 'number',
                'step'  => 1,
                'min'   => 0,
                'max'   => '',
                'std'   => '',
                'label' => __( 'Offset', 'trendingnews' ),
                'desc'  => __( 'Offsets are used to skip a certain number of WordPress posts before starting output. Set it to 0 if you do not wish to use this feature.', 'trendingnews' ),
            ),
            'orderby' => array(
                'type' => 'select',
                'std' => 'date',
                'label' => __('Order by', 'trendingnews'),
                'options' => array(
                    'date' => __('Date', 'trendingnews'),
                    'ID' => __('ID', 'trendingnews'),
                    'title' => __('Title', 'trendingnews'),
                    'rand' => __('Random', 'trendingnews'),
                ),
            ),
            'order' => array(
                'type' => 'select',
                'std' => 'desc',
                'label' => __('Order', 'trendingnews'),
                'options' => array(
                    'asc' => __('ASC', 'trendingnews'),
                    'desc' => __('DESC', 'trendingnews'),
                ),
            ),
            'show_counter' => array(
                'type' => 'checkbox',
                'label' => __('Show Counter', 'trendingnews'),
                'std' => true,
            ),
            'show_image' => array(
                'type' => 'checkbox',
                'label' => __('Show Image', 'trendingnews'),
                'std' => true,
            ),
            'image_size' => array(
                'type' => 'select',
                'label' => __('Image size', 'trendingnews'),
                'options' => array(
                    'thumbnail' => __('Thumbnail', 'trendingnews'),
                    'medium' => __('Medium', 'trendingnews'),
                    'medium_large' => __('Medium Large', 'trendingnews'),
                    'large' => __('Large', 'trendingnews'),
                    'full' => __('Full', 'trendingnews'),
                ),
                'std' => 'medium',

            ),
            'image_hover_effects' => array(
                'type' => 'select',
                'label' => __('Image hover effects', 'trendingnews'),
                'options' => array(
                    'hover-effect-shine' => __('Shine', 'trendingnews'),
                    'hover-effect-slide' => __('Slide', 'trendingnews'),
                    'hover-effect-zoom' => __('Zoom', 'trendingnews'),
                ),
                'std' => 'hover-effect-shine',
            ),
            'show_date' => array(
                'type' => 'checkbox',
                'label' => __('Show Date', 'trendingnews'),
                'std' => true,
            ),
            'date_format' => array(
                'type' => 'select',
                'label' => __('Date Format', 'trendingnews'),
                'options' => array(
                    'classic'   => __( 'Classic', 'trendingnews' ),
                    'time_ago' => __( 'Time Ago', 'trendingnews' ),
                ),
                'std' => 'classic',
            ),
            'show_author' => array(
                'type' => 'checkbox',
                'label' => __('Show Author', 'trendingnews'),
                'std' => false,
            ),
            'display_author_option' => array(
                'type' => 'select',
                'label' => __('Author Option', 'trendingnews'),
                'options' => array(
                    'with_label' => __('With Label', 'trendingnews'),
                    'with_icon' => __('With Icon', 'trendingnews'),
                    'with_avatar_image' => __('With Avatar Image', 'trendingnews'),
                ),
                'std' => 'with_icon',
            ),
            'author_text' => array(
                'type' => 'text',
                'label' => __('Author Text', 'trendingnews'),
                'std' => __('By:', 'trendingnews'),
                'desc' => __('This only works when the "With Label" option is selected under "Author Option"', 'trendingnews'),
            ),
            'show_category' => array(
                'type' => 'checkbox',
                'label' => __('Show Category', 'trendingnews'),
                'std' => true,
            ),
            'category_text' => array(
                'type' => 'text',
                'label' => __('Category Text', 'trendingnews'),
            ),
            'display_category_option' => array(
                'type' => 'select',
                'label' => __('Category Option', 'trendingnews'),
                'options' => array(
                    'none' => __('None', 'trendingnews'),
                    'has-background' => __('Has background', 'trendingnews'),
                    'has-text-color' => __('Has text color', 'trendingnews'),
                ),
                'std' => 'has-background',
            ),
            'number_of_cat' => array(
                'type' => 'number',
                'step' => 1,
                'min' => 1,
                'std' => 1,
                'label' => __('Number of Category to show', 'trendingnews'),
            ),
        );
    }

    /**
     * Query the posts and return them.
     */
    protected function get_posts($args, $instance)
    {
        $query_args = array(
            'posts_per_page' => !empty($instance['number']) ? absint($instance['number']) : $this->settings['number']['std'],
            'post_status' => 'publish',
            'no_found_rows' => 1,
            'orderby' => !empty($instance['orderby']) ? sanitize_text_field($instance['orderby']) : $this->settings['orderby']['std'],
            'order' => !empty($instance['order']) ? sanitize_text_field($instance['order']) : $this->settings['order']['std'],
            'offset' => !empty($instance['offset']) ? sanitize_text_field($instance['offset']) : $this->settings['offset']['std'],
            'ignore_sticky_posts' => 1
        );

        if ( isset($instance['offset']) && absint($instance['offset']) != 0 ) {
            $query_args['offset'] = absint($instance['offset']);
        }

        if (!empty($instance['category']) && -1 != $instance['category'] && 0 != $instance['category']) {
            $query_args['tax_query'][] = array(
                'taxonomy' => 'category',
                'field' => 'term_id',
                'terms' => absint($instance['category']),
            );
        }

        return new WP_Query(apply_filters('trendingnews_recent_posts_query_args', $query_args));
    }

    /**
     * Output widget content.
     */
    public function widget($args, $instance)
    {
        $posts = $this->get_posts($args, $instance);

        if (!$posts->have_posts()) {
            return;
        }

        echo $args['before_widget'];
        do_action('trendingnews_before_recent_posts_with_image');
        if (!empty($instance['title'])) {
            echo $args['before_title'] . esc_html($instance['title']) . $args['after_title'];
        }

        echo '<div class="wpi-recent-widget wpi-widget-list">';
        $counter = 1;
        while ($posts->have_posts()) {
            $posts->the_post();
            $this->render_post($instance, $counter);
            $counter++;
        }

        wp_reset_postdata();

        echo '</div>';

        do_action('trendingnews_after_recent_posts_with_image');
        echo $args['after_widget'];
    }

    /**
     * Render a single post item.
     */
    protected function render_post($instance, $counter)
    {
        $counter_class = '';   
        $style = !empty($instance['style']) ? $instance['style'] : $this->settings['style']['std'];
        $font_size = !empty($instance['font_size']) ? $instance['font_size'] : $this->settings['font_size']['std'];
        $font_style = !empty($instance['font_style']) ? $instance['font_style'] : $this->settings['font_style']['std'];

        $image_size = !empty($instance['image_size']) ? $instance['image_size'] : $this->settings['image_size']['std'];
        $image_hover_effects = !empty($instance['image_hover_effects']) ? $instance['image_hover_effects'] : $this->settings['image_hover_effects']['std'];
        $show_counter = !empty($instance['show_counter']) ? $instance['show_counter'] : $this->settings['show_counter']['std'];

        if ($show_counter) {
            $counter_class =  'has-post-counter'; 
        }

        $show_author = !empty($instance['show_author']) ? $instance['show_author'] : $this->settings['show_author']['std'];
        $author_text = !empty($instance['author_text']) ? $instance['author_text'] : $this->settings['author_text']['std'];
        $display_author_option = !empty($instance['display_author_option']) ? $instance['display_author_option'] : $this->settings['display_author_option']['std'];
        $category_text = !empty($instance['category_text']) ? $instance['category_text'] : '';
        $display_category_option = !empty($instance['display_category_option']) ? $instance['display_category_option'] : $this->settings['display_category_option']['std'];
        $number_of_cat = !empty($instance['number_of_cat']) ? absint($instance['number_of_cat']) : $this->settings['number_of_cat']['std'];

        ?>
        <article id="recent-post-<?php echo the_ID(); ?>" <?php post_class('wpi-post  ' . esc_attr($counter_class) . ' ' . esc_attr($style) . ' '); ?>>
            <?php if (!empty($instance['show_counter']) && $instance['show_counter']) { ?>
                <div class="wpi-post-counter">
                    <span><?php echo $counter; ?></span>
                </div>
            <?php } ?>
            <?php if (has_post_thumbnail() && !empty($instance['show_image'])) : ?>
                <div class="entry-image entry-image-thumbnail image-hover-effect <?php echo $image_hover_effects; ?>">
                    <a class="post-thumbnail" href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                        <?php
                        the_post_thumbnail(
                            $image_size,
                            array(
                                'alt' => the_title_attribute(
                                    array(
                                        'echo' => false,
                                    )
                                ),
                            )
                        );
                        ?>
                    </a>
                </div>
            <?php endif; ?>
            <div class="entry-details">
                <?php
                if (!empty($instance['show_category']) && $instance['show_category']) {
                    trendingnews_post_category($display_category_option, $category_text, $number_of_cat);
                }
                ?>
                <header class="entry-header">
                    <?php the_title('<h3 class="entry-title ' . $font_size . ' ' . $font_style . '"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                </header>

                <div class="entry-meta-wrapper">
                    <?php if (!empty($instance['show_date']) && $instance['show_date']) : ?>
                        <div class="entry-meta entry-date posted-on">
                            <span class="screen-reader-text"><?php _e('Post Date', 'trendingnews'); ?></span>
                            <?php trendingnews_the_theme_svg('calendar'); ?>
                            <?php
                            $date_format = !empty($instance['date_format']) ? $instance['date_format'] : 'classic';
                                trendingnews_posted_on($date_format);
                            ?>
                        </div>
                    <?php endif; ?>
                    <?php if (!empty($instance['show_author']) && $instance['show_author']) : ?>

                            <?php
                            if ($show_author) {
                                trendingnews_posted_by($display_author_option, $author_text);
                            }
                            ?>

                    <?php endif; ?>
                </div>

            </div>
        </article>
        <?php
    }
}