<?php
/**
 * TrendingNews Admin Class.
 *
 * @package TrendingNews
 * @since   1.0.0
 */
if (!defined('ABSPATH')) {
    exit;
}
if (!class_exists('TrendingNews_Admin')) :
    /**
     * TrendingNews_Admin Class.
     */
    class TrendingNews_Admin
    {
        /**
         * Constructor.
         */
        public function __construct()
        {
            add_action('admin_enqueue_scripts', array($this, 'enqueue_scripts'));
        }

        /**
         * Localize array for import button AJAX request.
         */
        public function enqueue_scripts()
        {

            $suffix = (defined('SCRIPT_DEBUG') && SCRIPT_DEBUG) ? '' : '.min';

            $file_name = is_rtl() ? 'admin-rtl' . $suffix . '.css' : 'admin' . $suffix . '.css';

            wp_enqueue_style(
                'trendingnews-admin-style',
                get_template_directory_uri() . '/inc/admin/dashboard/css/' . $file_name,
                array(),
                TRENDINGNEWS_VERSION
            );


            wp_enqueue_script('trendingnews-plugin-install-helper', get_template_directory_uri() . '/inc/admin/dashboard/js/admin.js', array('jquery'), TRENDINGNEWS_VERSION, true);
            $welcome_data = array(
                'uri' => esc_url(admin_url('/themes.php?page=trendingnews&tab=starter-templates')),
                'btn_text' => esc_html__('Processing...', 'trendingnews'),
                'nonce' => wp_create_nonce('trendingnews_demo_import_nonce'),
                'admin_url' => esc_url(admin_url()),
                'ajaxurl' => admin_url('admin-ajax.php'), // Include this line for using admin-ajax.php
            );
            wp_localize_script('trendingnews-plugin-install-helper', 'trendingnewsRedirectDemoPage', $welcome_data);
        }
    }
endif;
return new TrendingNews_Admin();
