<?php
$wp_customize->add_section(
   'topbar_options' ,
    array(
        'title' => __( 'Topbar Options', 'trendingnews' ),
        'panel' => 'header_options_panel',
    )
);

/*Enable Top Bar*/
$wp_customize->add_setting(
    'trendingnews_options[enable_top_bar]',
    array(
        'default'           => $trendingnews_default['enable_top_bar'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_top_bar]',
    array(
        'label'    => __( 'Enable Top Bar', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[hide_topbar_on_mobile]',
    array(
        'default'           => $trendingnews_default['hide_topbar_on_mobile'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[hide_topbar_on_mobile]',
    array(
        'label'    => __( 'Hide Top Bar on Mobile', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);



/*Enable Today's Date*/
$wp_customize->add_setting(
    'trendingnews_options[enable_header_time]',
    array(
        'default'           => $trendingnews_default['enable_header_time'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_header_time]',
    array(
        'label'    => __( 'Enable Current Time', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);

/*Enable Today's Date*/
$wp_customize->add_setting(
    'trendingnews_options[enable_header_date]',
    array(
        'default'           => $trendingnews_default['enable_header_date'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_header_date]',
    array(
        'label'    => __( 'Enable Today\'s Date', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);

// Date Label Text
$wp_customize->add_setting(
    'trendingnews_options[date_label_text]',
    array(
        'default'           => $trendingnews_default['date_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[date_label_text]',
    array(
        'label'           => __( 'Date Label Text', 'trendingnews' ),
        'description'     => __( 'Leave empty if you want to use the default text "Today".', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'text',
    )
);


/*Todays Date Format*/
$wp_customize->add_setting(
    'trendingnews_options[todays_date_format]',
    array(
        'default'           => $trendingnews_default['todays_date_format'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[todays_date_format]',
    array(
        'label'    => __( 'Today\'s Date Format', 'trendingnews' ),
        'description' => sprintf( wp_kses( __( '<a href="%s" target="_blank">Date and Time Formatting Documentation</a>.', 'trendingnews' ), array(  'a' => array( 'href' => array(), 'target' => array() ) ) ), esc_url( 'https://wordpress.org/support/article/formatting-date-and-time' ) ),
        'section'  => 'topbar_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_social_nav_on_topbar]',
    array(
        'default'           => $trendingnews_default['enable_social_nav_on_topbar'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_social_nav_on_topbar]',
    array(
        'label'    => __( 'Enable Social Nav on TopBar', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_top_bar_social_menu_style]',
    array(
        'default'           => $trendingnews_default['select_top_bar_social_menu_style'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_top_bar_social_menu_style]',
    array(
        'label'         => esc_html__( 'Social Menu Options', 'trendingnews' ),
        'section'     => 'topbar_options',
        'type'        => 'select',
        'choices'       => trendingnews_social_menu_style(),


    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_social_nav_border_radius]',
    array(
        'default'           => $trendingnews_default['enable_social_nav_border_radius'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_social_nav_border_radius]',
    array(
        'label'    => __( 'Enable Border Radius', 'trendingnews' ),
        'section'  => 'topbar_options',
        'type'     => 'checkbox',
    )
);
