<?php
// Tags Posts Options.
$wp_customize->add_section(
	'home_page_tags_options',
	array(
		'title' => __( 'Tags Options', 'trendingnews' ),
		'panel' => 'header_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_tags]',
    array(
        'default'           => $trendingnews_default['enable_tags'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_tags]',
    array(
		'label'    => __( 'Enable Tags Section', 'trendingnews' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_tags_only_on_frontpage]',
    array(
        'default' => $trendingnews_default['enable_tags_only_on_frontpage'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_tags_only_on_frontpage]',
    array(
        'label' => __('Display only on the Homepage', 'trendingnews'),
        'section' => 'home_page_tags_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_tags_label]',
    array(
        'default'           => $trendingnews_default['enable_tags_label'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);

$wp_customize->add_control(
    'trendingnews_options[enable_tags_label]',
    array(
        'label'           => __( 'Enable Tags Label', 'trendingnews' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);

// Tags Label Style.
$wp_customize->add_setting(
    'trendingnews_options[tags_label_style]',
    array(
        'default'           => $trendingnews_default['tags_label_style'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[tags_label_style]',
    array(
        'label'           => __( 'Label Style', 'trendingnews' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'select',
        'choices'         => array(
            'style_1' => __( 'Plain', 'trendingnews' ),
            'style_2' => __( 'With Icon', 'trendingnews' ),
        ),
    )
);


// Tags Label Text.
$wp_customize->add_setting(
    'trendingnews_options[tags_label_text]',
    array(
        'default'           => $trendingnews_default['tags_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[tags_label_text]',
    array(
        'label'           => __( 'Tags Label Text', 'trendingnews' ),
        'description'     => __( 'Leave empty if you want it blank', 'trendingnews' ),
        'section'         => 'home_page_tags_options',
        'type'            => 'text',
    )
);

// No of posts.
$wp_customize->add_setting(
    'trendingnews_options[no_of_tags]',
    array(
        'default'           => $trendingnews_default['no_of_tags'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[no_of_tags]',
    array(
		'label'           => __( 'Number of Tags', 'trendingnews' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'number',
    )
);


// Posts Orderby.
$wp_customize->add_setting(
    'trendingnews_options[tags_orderby]',
    array(
        'default'           => $trendingnews_default['tags_orderby'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[tags_orderby]',
    array(
		'label'           => __( 'Orderby', 'trendingnews' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'trendingnews' ),
			'id'    => __( 'ID', 'trendingnews' ),
			'title' => __( 'Title', 'trendingnews' ),
			'rand'  => __( 'Random', 'trendingnews' ),
		),
    )
);


// Posts Order.
$wp_customize->add_setting(
    'trendingnews_options[tags_order]',
    array(
        'default'           => $trendingnews_default['tags_order'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[tags_order]',
    array(
		'label'           => __( 'Orderby', 'trendingnews' ),
		'section'         => 'home_page_tags_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'trendingnews' ),
			'desc' => __( 'DESC', 'trendingnews' ),
		),
    )
);


$wp_customize->add_setting(
    'trendingnews_options[hide_tags_label_responsive]',
    array(
        'default'           => $trendingnews_default['hide_tags_label_responsive'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[hide_tags_label_responsive]',
    array(
		'label'           => __( 'Hide Label on Responsive', 'trendingnews' ),
        'section'     => 'home_page_tags_options',
        'type'        => 'checkbox',
    )
);