<?php
/**
 * All settings related to footer recommended post.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'split_block',
	array(
		'title' => esc_html__( 'Split Block Section', 'trendingnews' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_split_block]',
    array(
        'default'           => $trendingnews_default['enable_split_block'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_split_block]',
    array(
        'label'       => esc_html__( 'Enable Split Block', 'trendingnews' ),
        'section'     => 'split_block',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
  'trendingnews_options[split_block_title]',
  array(
      'default' => $trendingnews_default['split_block_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'trendingnews_options[split_block_title]',
  array(
      'label' => __('Section Title', 'trendingnews'),
      'section' => 'split_block',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'trendingnews_options[split_block_category]',
    array(
        'default'           => $trendingnews_default['split_block_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[split_block_category]',
        array(
            'label'           => __( 'Choose Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'split_block',
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[split_block_offset]',
    array(
        'default' => $trendingnews_default['split_block_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[split_block_offset]',
    array(
        'label' => __('Post Offset', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'number',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_split_block_author_meta]',
    array(
        'default' => $trendingnews_default['enable_split_block_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_split_block_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_split_block_author_meta]',
    array(
        'default' => $trendingnews_default['select_split_block_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[split_block_author_meta_title]',
    array(
        'default' => $trendingnews_default['split_block_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[split_block_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_split_block_date_meta]',
    array(
        'default' => $trendingnews_default['enable_split_block_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_split_block_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_split_block_date]',
    array(
        'default' => $trendingnews_default['select_split_block_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_split_block_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_split_block_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_split_block_date_format]',
    array(
        'default' => $trendingnews_default['select_split_block_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_split_block_category_meta]',
    array(
        'default' => $trendingnews_default['enable_split_block_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_split_block_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_split_block_number_of_category]',
    array(
        'default' => $trendingnews_default['select_split_block_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[split_block_category_label]',
    array(
        'default' => $trendingnews_default['split_block_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[split_block_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_split_block_category_color]',
    array(
        'default' => $trendingnews_default['select_split_block_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_split_block_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'split_block',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);