<?php
$wp_customize->add_section(
    'homepage_slider_banner_option',
    array(
        'title' => __('Carousel Banner', 'trendingnews'),
        'panel' => 'front_page_theme_options_panel',
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'trendingnews_options[enable_slider_banner_section]',
    array(
        'default' => $trendingnews_default['enable_slider_banner_section'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_slider_banner_section]',
    array(
        'label' => __('Enable Carousel Banner Section', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[title_slider_banner_section]',
    array(
        'default'           => $trendingnews_default['title_slider_banner_section'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[title_slider_banner_section]',
    array(
        'label'    => __( 'Section Title', 'trendingnews' ),
        'section'  => 'homepage_slider_banner_option',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[number_of_slider_post]',
    array(
        'default' => $trendingnews_default['number_of_slider_post'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[number_of_slider_post]',
    array(
        'label' => __('Post In Slider', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            '3' => __('3', 'trendingnews'),
            '4' => __('4', 'trendingnews'),
            '5' => __('5', 'trendingnews'),
            '6' => __('6', 'trendingnews'),
            '7' => __('7', 'trendingnews'),
            '8' => __('8', 'trendingnews'),
        ),
    )
);


$wp_customize->add_setting(
    'trendingnews_options[banner_section_cat]',
    array(
        'default'           => $trendingnews_default['banner_section_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[banner_section_cat]',
        array(
            'label'           => __( 'Choose  Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'homepage_slider_banner_option',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[slider_banner_offset]',
    array(
        'default' => $trendingnews_default['slider_banner_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[slider_banner_offset]',
    array(
        'label' => __('Slider Post Offset', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_banner_post_description]',
    array(
        'default' => $trendingnews_default['enable_banner_post_description'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_post_description]',
    array(
        'label' => __('Enable Post Description', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_banner_overlay]',
    array(
        'default' => $trendingnews_default['enable_banner_overlay'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_overlay]',
    array(
        'label' => __('Enable Banner Overlay', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[slider_post_content_alignment]',
    array(
        'default' => $trendingnews_default['slider_post_content_alignment'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[slider_post_content_alignment]',
    array(
        'label' => __('Content Vertical Alignment', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => array(
            'banner-description-top' => __('Vertical alignment top', 'trendingnews'),
            'banner-description-space' => __('Vertical alignment space between', 'trendingnews'),
            'banner-description-bottom' => __('Vertical alignment bottom', 'trendingnews'),
        ),
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Banner Slider Meta', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_banner',
            'section' => 'homepage_slider_banner_option',
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_banner_slider_author_meta]',
    array(
        'default' => $trendingnews_default['enable_banner_slider_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_author_meta]',
    array(
        'default' => $trendingnews_default['select_banner_slider_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[banner_slider_author_meta_title]',
    array(
        'default' => $trendingnews_default['banner_slider_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[banner_slider_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_banner_slider_date_meta]',
    array(
        'default' => $trendingnews_default['enable_banner_slider_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_slider_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_date]',
    array(
        'default' => $trendingnews_default['select_banner_slider_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_banner_slider_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_date_format]',
    array(
        'default' => $trendingnews_default['select_banner_slider_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_banner_slider_category_meta]',
    array(
        'default' => $trendingnews_default['enable_banner_slider_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_slider_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_number_of_category]',
    array(
        'default' => $trendingnews_default['select_banner_slider_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[banner_slider_category_label]',
    array(
        'default' => $trendingnews_default['banner_slider_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[banner_slider_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_banner_slider_category_color]',
    array(
        'default' => $trendingnews_default['select_banner_slider_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_banner_slider_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);

/* Home Page Layout */
$wp_customize->add_setting(
    'trendingnews_options[enable_banner_control_icon]',
    array(
        'default' => $trendingnews_default['enable_banner_control_icon'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_banner_control_icon]',
    array(
        'label' => __('Enable Slider Control', 'trendingnews'),
        'section' => 'homepage_slider_banner_option',
        'type' => 'checkbox',
    )
);