<?php
$wp_customize->add_section(
	'sidebar_options',
	array(
		'title' => esc_html__( 'SideBar Options', 'trendingnews' ),
		'panel' => 'archive_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[sidebar_layout_option]',
    array(
        'default'           => $trendingnews_default['sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'trendingnews_sanitize_radio'
    )
);

$wp_customize->add_control(
    new TrendingNews_Custom_Radio_Image_Control(
        $wp_customize,
        'trendingnews_options[sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (archive)', 'trendingnews' ),
            'section'       => 'sidebar_options',
            'choices'       => trendingnews_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[single_sidebar_layout_option]',
    array(
        'default'           => $trendingnews_default['single_sidebar_layout_option'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'trendingnews_sanitize_radio'
    )
);

$wp_customize->add_control(
    new TrendingNews_Custom_Radio_Image_Control(
        $wp_customize,
        'trendingnews_options[single_sidebar_layout_option]',
        array(
            'label'         => esc_html__( 'Select Sidebar Layout (Single)', 'trendingnews' ),
            'section'       => 'sidebar_options',
            'choices'       => trendingnews_get_sidebar_layouts(),
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_sidebar_fix_archive]',
    array(
        'default'           => $trendingnews_default['enable_sidebar_fix_archive'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_sidebar_fix_archive]',
    array(
        'label'    => __( 'Enable Sticky Sidebar', 'trendingnews' ),
        'section'     => 'sidebar_options',
        'type'        => 'checkbox',
    )
);
