<?php
$wp_customize->add_section(
    'single_author_options',
    array(
        'title' => esc_html__( 'Single Author Post Options', 'trendingnews' ),
        'panel' => 'single_options_panel',
    )
);
/*Show Author Posts
*-----------------------------------------*/
$wp_customize->add_setting(
    'trendingnews_options[show_author_posts]',
    array(
        'default'           => $trendingnews_default['show_author_posts'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[show_author_posts]',
    array(
        'label'    => __( 'Show Author Posts', 'trendingnews' ),
        'section'  => 'single_author_options',
        'type'     => 'checkbox',
    )
);

/*Author Posts Text.*/
$wp_customize->add_setting(
    'trendingnews_options[author_posts_text]',
    array(
        'default'           => $trendingnews_default['author_posts_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_text]',
    array(
        'label'    => __( 'Author Posts Text', 'trendingnews' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

/* Number of Author Posts */
$wp_customize->add_setting(
    'trendingnews_options[no_of_author_posts]',
    array(
        'default'           => $trendingnews_default['no_of_author_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[no_of_author_posts]',
    array(
        'label'       => __( 'Number of Author Posts', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'number',
    )
);



// No of posts offset.
$wp_customize->add_setting(
    'trendingnews_options[author_posts_number_of_post_offsets]',
    array(
        'default' => $trendingnews_default['author_posts_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'trendingnews'),
        'section' => 'single_author_options',
        'type' => 'number',
    )
);


/*Author Posts Orderby*/
$wp_customize->add_setting(
    'trendingnews_options[author_posts_orderby]',
    array(
        'default'           => $trendingnews_default['author_posts_orderby'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_orderby]',
    array(
        'label'       => __( 'Orderby', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'date' => __('Date', 'trendingnews'),
            'id' => __('ID', 'trendingnews'),
            'title' => __('Title', 'trendingnews'),
            'rand' => __('Random', 'trendingnews'),
        ),
    )
);

/*Author Posts Order*/
$wp_customize->add_setting(
    'trendingnews_options[author_posts_order]',
    array(
        'default'           => $trendingnews_default['author_posts_order'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_order]',
    array(
        'label'       => __( 'Order', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices' => array(
            'asc' => __('ASC', 'trendingnews'),
            'desc' => __('DESC', 'trendingnews'),
        ),
    )
);



$wp_customize->add_setting(
    'trendingnews_options[enable_author_posts_author_meta]',
    array(
        'default'           => $trendingnews_default['enable_author_posts_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_author_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Show Author Meta', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_posts_author_meta]',
    array(
        'default'           => $trendingnews_default['select_author_posts_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Author Meta Display Options', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => trendingnews_author_meta(),


    )
);

$wp_customize->add_setting(
    'trendingnews_options[author_posts_author_meta_title]',
    array(
        'default'           => $trendingnews_default['author_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'trendingnews' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_author_posts_date_meta]',
    array(
        'default'           => $trendingnews_default['enable_author_posts_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_author_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_posts_date]',
    array(
        'default'           => $trendingnews_default['select_author_posts_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_posts_date]',
    array(
        'label'         => esc_html__( 'Select Date Meta', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => trendingnews_date_meta(),

    )
);

$wp_customize->add_setting(
    'trendingnews_options[single_related_post_date_meta_title]',
    array(
        'default'           => $trendingnews_default['single_related_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[single_related_post_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'trendingnews' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_posts_date_format]',
    array(
        'default'           => $trendingnews_default['select_author_posts_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => trendingnews_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_author_posts_category_meta]',
    array(
        'default'           => $trendingnews_default['enable_author_posts_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_author_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_posts_number_of_category]',
    array(
        'default'           => $trendingnews_default['select_author_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'trendingnews' ),
        'section'     => 'single_related_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[author_posts_category_label]',
    array(
        'default'           => $trendingnews_default['author_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[author_posts_category_label]',
    array(
        'label'    => __( 'Category Label', 'trendingnews' ),
        'section'  => 'single_author_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_author_posts_category_color]',
    array(
        'default'           => $trendingnews_default['select_author_posts_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_author_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'trendingnews' ),
        'section'     => 'single_author_options',
        'type'        => 'select',
        'choices'       => trendingnews_category_color(),

    )
);
