<?php
$wp_customize->add_section(
   'search_latest_post_options' ,
    array(
        'title' => __( 'Within Search Modal', 'trendingnews' ),
        'panel' => 'header_options_panel',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_search_latest_posts]',
    array(
        'default'           => $trendingnews_default['enable_search_latest_posts'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_search_latest_posts]',
    array(
		'label'    => __( 'Enable Trending', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_search_latest_label]',
    array(
        'default'           => $trendingnews_default['enable_search_latest_label'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_search_latest_label]',
    array(
		'label'           => __( 'Enable Trending Label', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

// Trending Label Text.
$wp_customize->add_setting(
    'trendingnews_options[search_latest_label_text]',
    array(
        'default'           => $trendingnews_default['search_latest_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[search_latest_label_text]',
    array(
        'label'           => __( 'Trending Label Text', 'trendingnews' ),
        'section'         => 'search_latest_post_options',
        'type'            => 'text',
    )
);

// Trending Posts Category.
$wp_customize->add_setting(
	'trendingnews_options[search_latest_posts_cat]',
	array(
		'default'           => $trendingnews_default['search_latest_posts_cat'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	new TrendingNews_Dropdown_Taxonomies_Control(
		$wp_customize,
		'trendingnews_options[search_latest_posts_cat]',
		array(
			'label'           => __( 'Choose Trending posts category', 'trendingnews' ),
			'section'         => 'search_latest_post_options',
		)
	)
);

// No of posts.
$wp_customize->add_setting(
	'trendingnews_options[no_of_search_latest_posts]',
	array(
		'default'           => $trendingnews_default['no_of_search_latest_posts'],
		'sanitize_callback' => 'absint',
	)
);
$wp_customize->add_control(
	'trendingnews_options[no_of_search_latest_posts]',
	array(
		'label'           => __( 'Number of Posts', 'trendingnews' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'number',
	)
);

// Posts Orderby.
$wp_customize->add_setting(
	'trendingnews_options[search_latest_posts_orderby]',
	array(
		'default'           => $trendingnews_default['search_latest_posts_orderby'],
		'sanitize_callback' => 'trendingnews_sanitize_select',
	)
);
$wp_customize->add_control(
	'trendingnews_options[search_latest_posts_orderby]',
	array(
		'label'           => __( 'Orderby', 'trendingnews' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'select',
		'choices'         => array(
			'date'  => __( 'Date', 'trendingnews' ),
			'id'    => __( 'ID', 'trendingnews' ),
			'title' => __( 'Title', 'trendingnews' ),
			'rand'  => __( 'Random', 'trendingnews' ),
		),
	)
);

// Posts Order.
$wp_customize->add_setting(
	'trendingnews_options[search_latest_posts_order]',
	array(
		'default'           => $trendingnews_default['search_latest_posts_order'],
		'sanitize_callback' => 'trendingnews_sanitize_select',
	)
);
$wp_customize->add_control(
	'trendingnews_options[search_latest_posts_order]',
	array(
		'label'           => __( 'Order', 'trendingnews' ),
		'section'         => 'search_latest_post_options',
		'type'            => 'select',
		'choices'         => array(
			'asc'  => __( 'ASC', 'trendingnews' ),
			'desc' => __( 'DESC', 'trendingnews' ),
		),
	)
);


$wp_customize->add_setting(
    'trendingnews_options[enable_search_latest_posts_author_meta]',
    array(
        'default'           => $trendingnews_default['enable_search_latest_posts_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_search_latest_posts_author_meta]',
    array(
        'label'       => esc_html__( 'Display Author Meta', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_search_latest_posts_author_meta]',
    array(
        'default'           => $trendingnews_default['select_search_latest_posts_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_search_latest_posts_author_meta]',
    array(
        'label'         => esc_html__( 'Select Author Meta', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => trendingnews_author_meta(),


    )
);

$wp_customize->add_setting(
    'trendingnews_options[search_latest_posts_author_meta_title]',
    array(
        'default'           => $trendingnews_default['search_latest_posts_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[search_latest_posts_author_meta_title]',
    array(
        'label'    => __( 'Author Meta Text', 'trendingnews' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_search_latest_posts_date_meta]',
    array(
        'default'           => $trendingnews_default['enable_search_latest_posts_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_search_latest_posts_date_meta]',
    array(
        'label'       => esc_html__( 'Display Published Date', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_search_latest_posts_date]',
    array(
        'default'           => $trendingnews_default['select_search_latest_posts_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_search_latest_posts_date]',
    array(
        'label'         => esc_html__( 'Select Date Meta', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => trendingnews_date_meta(),

    )
);

$wp_customize->add_setting(
    'trendingnews_options[single_search_latest_post_date_meta_title]',
    array(
        'default'           => $trendingnews_default['single_search_latest_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[single_search_latest_post_date_meta_title]',
    array(
        'label'    => __( 'Date Meta Text', 'trendingnews' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_search_latest_posts_date_format]',
    array(
        'default'           => $trendingnews_default['select_search_latest_posts_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_search_latest_posts_date_format]',
    array(
        'label'         => esc_html__( 'Select Date Format', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => trendingnews_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_search_latest_posts_category_meta]',
    array(
        'default'           => $trendingnews_default['enable_search_latest_posts_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_search_latest_posts_category_meta]',
    array(
        'label'       => esc_html__( 'Enable Category Meta', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_search_latest_posts_number_of_category]',
    array(
        'default'           => $trendingnews_default['select_search_latest_posts_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_search_latest_posts_number_of_category]',
    array(
        'label'       => __( 'Number of Category', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[search_latest_posts_category_label]',
    array(
        'default'           => $trendingnews_default['search_latest_posts_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[search_latest_posts_category_label]',
    array(
        'label'       => esc_html__( 'Category Label', 'trendingnews' ),
        'section'  => 'search_latest_post_options',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_search_latest_posts_category_color]',
    array(
        'default'           => $trendingnews_default['select_search_latest_posts_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_search_latest_posts_category_color]',
    array(
        'label'         => esc_html__( 'Select Category Color', 'trendingnews' ),
        'section'     => 'search_latest_post_options',
        'type'        => 'select',
        'choices'       => trendingnews_category_color(),

    )
);