<?php
/**
 * All settings related to preloader.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'preloader_options',
	array(
		'title' => esc_html__( 'Preloader Options', 'trendingnews' ),
		'panel' => 'general_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_preloader_options]',
    array(
        'default'           => $trendingnews_default['enable_preloader_options'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_preloader_options]',
    array(
        'label'       => esc_html__( 'Enable Preloader Option', 'trendingnews' ),
        'section'     => 'preloader_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[trendingnews_preloader_style]',
    array(
        'default'           => $trendingnews_default['trendingnews_preloader_style'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[trendingnews_preloader_style]',
    array(
        'label'         => esc_html__( 'Select Preloader Style', 'trendingnews' ),
        'section'     => 'preloader_options',
        'type'        => 'select',
        'choices'       => trendingnews_preloader_style_option(),

    )
);
