<?php
// Popular Posts Options.
$wp_customize->add_section(
    'home_page_popular_post_options',
    array(
        'title' => __('Popular Options', 'trendingnews'),
        'panel' => 'header_options_panel',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_posts]',
    array(
        'default' => $trendingnews_default['enable_popular_posts'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_posts]',
    array(
        'label' => __('Enable Popular Section', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_popular_only_on_frontpage]',
    array(
        'default' => $trendingnews_default['enable_popular_only_on_frontpage'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_only_on_frontpage]',
    array(
        'label' => __('Display only on the Homepage', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_popular_label]',
    array(
        'default'           => $trendingnews_default['enable_popular_label'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_label]',
    array(
        'label'           => __( 'Enable Popular Label', 'trendingnews' ),
        'section'     => 'home_page_popular_post_options',
        'type'        => 'checkbox',
    )
);

// Popular Label Text.
$wp_customize->add_setting(
    'trendingnews_options[popular_label_text]',
    array(
        'default'           => $trendingnews_default['popular_label_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_label_text]',
    array(
        'label'           => __( 'Popular Label', 'trendingnews' ),
        'description'     => __( 'Leave blank to use the default text "Latest".', 'trendingnews' ),
        'section'         => 'home_page_popular_post_options',
        'type'            => 'text',
    )
);


// Popular Posts Category.
$wp_customize->add_setting(
    'trendingnews_options[popular_post_cat]',
    array(
        'default' => $trendingnews_default['popular_post_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[popular_post_cat]',
        array(
            'label' => __('Choose Category', 'trendingnews'),
            'section' => 'home_page_popular_post_options',
        )
    )
);
// No of posts.
$wp_customize->add_setting(
    'trendingnews_options[no_of_popular_posts]',
    array(
        'default' => $trendingnews_default['no_of_popular_posts'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[no_of_popular_posts]',
    array(
        'label' => __('Number of Posts', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

// No of posts offset.
$wp_customize->add_setting(
    'trendingnews_options[popular_posts_number_of_post_offsets]',
    array(
        'default' => $trendingnews_default['popular_posts_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_posts_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);


// Posts Orderby.
$wp_customize->add_setting(
    'trendingnews_options[popular_post_orderby]',
    array(
        'default' => $trendingnews_default['popular_post_orderby'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_post_orderby]',
    array(
        'label' => __('Orderby', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'trendingnews'),
            'id' => __('ID', 'trendingnews'),
            'title' => __('Title', 'trendingnews'),
            'rand' => __('Random', 'trendingnews'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'trendingnews_options[popular_post_order]',
    array(
        'default' => $trendingnews_default['popular_post_order'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_post_order]',
    array(
        'label' => __('Order', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'trendingnews'),
            'desc' => __('DESC', 'trendingnews'),
        ),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_post_author_meta]',
    array(
        'default' => $trendingnews_default['enable_popular_post_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_popular_post_author_meta]',
    array(
        'default' => $trendingnews_default['select_popular_post_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[popular_post_author_meta_title]',
    array(
        'default' => $trendingnews_default['popular_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_post_date_meta]',
    array(
        'default' => $trendingnews_default['enable_popular_post_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_popular_post_date]',
    array(
        'default' => $trendingnews_default['select_popular_post_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_post_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_popular_post_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_popular_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_post_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_popular_post_date_format]',
    array(
        'default' => $trendingnews_default['select_popular_post_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_popular_category_meta]',
    array(
        'default' => $trendingnews_default['enable_popular_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_popular_number_of_category]',
    array(
        'default' => $trendingnews_default['select_popular_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[popular_post_offset_number]',
    array(
        'default' => $trendingnews_default['popular_post_offset_number'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_post_offset_number]',
    array(
        'label' => __('Post Offset', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[popular_category_label]',
    array(
        'default' => $trendingnews_default['popular_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[popular_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_popular_category_color]',
    array(
        'default' => $trendingnews_default['select_popular_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_popular_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);

// Enable  Autoplay.
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_post_autoplay]',
    array(
        'default' => $trendingnews_default['enable_popular_post_autoplay'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_post_autoplay]',
    array(
        'label' => __('Enable Autoplay', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'trendingnews_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_post_arrows]',
    array(
        'default' => $trendingnews_default['enable_popular_post_arrows'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_post_arrows]',
    array(
        'label' => __('Enable Arrows', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'trendingnews_is_popular_post_enabled',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_popular_post_dots]',
    array(
        'default' => $trendingnews_default['enable_popular_post_dots'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_popular_post_dots]',
    array(
        'label' => __('Enable Dots', 'trendingnews'),
        'section' => 'home_page_popular_post_options',
        'type' => 'checkbox',
        'active_callback' => 'trendingnews_is_popular_post_enabled',
    )
);
