<?php
/**
 * All settings related to metro banner post.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'metro_banner_post',
	array(
		'title' => esc_html__( 'Metro Banner Section', 'trendingnews' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_metro_banner_section]',
    array(
        'default'           => $trendingnews_default['enable_metro_banner_section'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_metro_banner_section]',
    array(
        'label'       => esc_html__( 'Enable Metro Banner', 'trendingnews' ),
        'section'     => 'metro_banner_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[metro_banner_layout]',
    array(
        'default'           => $trendingnews_default['metro_banner_layout'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[metro_banner_layout]',
    array(
        'label'         => esc_html__( 'Select Layout Style', 'trendingnews' ),
        'section'     => 'metro_banner_post',
        'type'        => 'select',
        'choices'       => trendingnews_metro_style_option(),

    )
);

$wp_customize->add_setting(
    'trendingnews_options[metro_banner_category]',
    array(
        'default'           => $trendingnews_default['metro_banner_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[metro_banner_category]',
        array(
            'label'           => __( 'Choose Metro Banner Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'metro_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[metro_banner_category_offset]',
    array(
        'default' => $trendingnews_default['metro_banner_category_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[metro_banner_category_offset]',
    array(
        'label' => __('First Category Post Offset', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_banner',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_banner',
        array(
            'label'         => esc_html__( 'Metro Banner Section Meta', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_banner',
            'section' => 'metro_banner_post',
        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_metro_banner_author_meta]',
    array(
        'default' => $trendingnews_default['enable_metro_banner_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_metro_banner_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_author_meta]',
    array(
        'default' => $trendingnews_default['select_metro_banner_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[metro_banner_author_meta_title]',
    array(
        'default' => $trendingnews_default['metro_banner_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[metro_banner_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_metro_banner_date_meta]',
    array(
        'default' => $trendingnews_default['enable_metro_banner_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_metro_banner_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_date]',
    array(
        'default' => $trendingnews_default['select_metro_banner_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_metro_banner_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_date_format]',
    array(
        'default' => $trendingnews_default['select_metro_banner_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_metro_banner_category_meta]',
    array(
        'default' => $trendingnews_default['enable_metro_banner_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_metro_banner_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_number_of_category]',
    array(
        'default' => $trendingnews_default['select_metro_banner_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[metro_banner_category_label]',
    array(
        'default' => $trendingnews_default['metro_banner_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[metro_banner_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_metro_banner_category_color]',
    array(
        'default' => $trendingnews_default['select_metro_banner_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_metro_banner_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'metro_banner_post',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);