<?php
$wp_customize->add_section(
   'header_style_options' ,
    array(
        'title' => __( 'Header Layout', 'trendingnews' ),
        'panel' => 'header_options_panel',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[select_header_layout_style]',
    array(
        'default'           => $trendingnews_default['select_header_layout_style'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'trendingnews_sanitize_radio'
    )
);

$wp_customize->add_control(
    new TrendingNews_Custom_Radio_Image_Control(
        $wp_customize,
        'trendingnews_options[select_header_layout_style]',
        array(
            'label'         => esc_html__( 'Select Header Layout', 'trendingnews' ),
            'section'       => 'header_style_options',
            'choices'       => trendingnews_get_header_layout(),
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[enable_header_advertisement]',
    array(
        'default'           => $trendingnews_default['enable_header_advertisement'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_header_advertisement]',
    array(
        'label'    => __( 'Enable Header Advertisement', 'trendingnews' ),
        'section'     => 'header_style_options',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[header_advert_image]',
    array(
        'default' => $trendingnews_default['header_advert_image'],
        'sanitize_callback' => 'trendingnews_sanitize_image',
    )
);
$wp_customize->add_control(
    new WP_Customize_Image_Control(
        $wp_customize,
        'trendingnews_options[header_advert_image]',
        array(
            'label' => __('Upload Banner Advertisement', 'trendingnews'),
            'section' => 'header_style_options',
            'active_callback' => 'trendingnews_header_advertisement',

        )
    )
);


$wp_customize->add_setting(
    'trendingnews_options[header_advert_image_url]',
    array(
        'default'           => $trendingnews_default['header_advert_image_url'],
        'sanitize_callback' => 'esc_url_raw',
    )
);
$wp_customize->add_control(
    'trendingnews_options[header_advert_image_url]',
    array(
        'label'    => __( 'Banner Advertisement URL', 'trendingnews' ),
        'section'  => 'header_style_options',
        'type'     => 'text',
        'active_callback' => 'trendingnews_header_advertisement',

    )
);