<?php
// Frontline Posts Options.
$wp_customize->add_section(
    'home_page_frontline_options',
    array(
        'title' => __('Frontline Section', 'trendingnews'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_frontlines]',
    array(
        'default' => $trendingnews_default['enable_frontlines'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_frontlines]',
    array(
        'label' => __('Enable Frontline', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);

// Frontline Posts Category.
$wp_customize->add_setting(
    'trendingnews_options[frontline_cat]',
    array(
        'default' => $trendingnews_default['frontline_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[frontline_cat]',
        array(
            'label' => __('Choose Frontline category', 'trendingnews'),
            'section' => 'home_page_frontline_options',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[frontline_layout_style]',
    array(
        'default' => $trendingnews_default['frontline_layout_style'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontline_layout_style]',
    array(
        'label' => __('Select Layout Style', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'frontline-layout-1' => __('Layout - 1', 'trendingnews'),
            'frontline-layout-2' => __('Layout - 2', 'trendingnews'),
            'frontline-layout-3' => __('Layout - 3', 'trendingnews'),
        ),
    )
);
// No of posts.
$wp_customize->add_setting(
    'trendingnews_options[no_of_frontlines]',
    array(
        'default' => $trendingnews_default['no_of_frontlines'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[no_of_frontlines]',
    array(
        'label' => __('Number of Posts', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);

// No of posts offset.
$wp_customize->add_setting(
    'trendingnews_options[frontlines_number_of_post_offsets]',
    array(
        'default' => $trendingnews_default['frontlines_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontlines_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
// Posts Orderby.
$wp_customize->add_setting(
    'trendingnews_options[frontline_orderby]',
    array(
        'default' => $trendingnews_default['frontline_orderby'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontline_orderby]',
    array(
        'label' => __('Orderby', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'trendingnews'),
            'id' => __('ID', 'trendingnews'),
            'title' => __('Title', 'trendingnews'),
            'rand' => __('Random', 'trendingnews'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'trendingnews_options[frontline_order]',
    array(
        'default' => $trendingnews_default['frontline_order'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontline_order]',
    array(
        'label' => __('Order', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'trendingnews'),
            'desc' => __('DESC', 'trendingnews'),
        ),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_frontline_author_meta]',
    array(
        'default' => $trendingnews_default['enable_frontline_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_frontline_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_frontline_author_meta]',
    array(
        'default' => $trendingnews_default['select_frontline_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[frontline_author_meta_title]',
    array(
        'default' => $trendingnews_default['frontline_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontline_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_frontline_date_meta]',
    array(
        'default' => $trendingnews_default['enable_frontline_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_frontline_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_frontline_date]',
    array(
        'default' => $trendingnews_default['select_frontline_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_frontline_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_frontline_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_frontline_date_format]',
    array(
        'default' => $trendingnews_default['select_frontline_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_frontline_category_meta]',
    array(
        'default' => $trendingnews_default['enable_frontline_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_frontline_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_frontline_number_of_category]',
    array(
        'default' => $trendingnews_default['select_frontline_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[frontline_category_label]',
    array(
        'default' => $trendingnews_default['frontline_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[frontline_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_frontline_category_color]',
    array(
        'default' => $trendingnews_default['select_frontline_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_frontline_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);
