<?php
// footer widget Options.
$wp_customize->add_section(
    'footer_widget_section',
    array(
        'title' => __('Footer Widget Options', 'trendingnews'),
        'panel' => 'footer_options_panel',
    )
);



/*Enable Footer Nav*/
$wp_customize->add_setting(
    'trendingnews_options[enable_footer_widget]',
    array(
        'default'           => $trendingnews_default['enable_footer_widget'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_footer_widget]',
    array(
        'label'       => __( 'Show Footer widgetarea', 'trendingnews' ),
        'section'     => 'footer_widget_section',
        'type'     => 'checkbox',
    )
);

// Option to choose footer column layout.
$wp_customize->add_setting(
	'trendingnews_options[footer_column_layout]',
	array(
		'default'           => $trendingnews_default['footer_column_layout'],
		'sanitize_callback' => 'trendingnews_sanitize_radio',
	)
);
$wp_customize->add_control(
	new TrendingNews_Custom_Radio_Image_Control(
		$wp_customize,
		'trendingnews_options[footer_column_layout]',
		array(
			'label'       => __( 'Footer Column Layout', 'trendingnews' ),
			'description' => __( 'Some footer widgetareas will not be used based on the footer column layout chosen. Also make sure to insert at least one widget on the respective widgetarea for it to display.', 'trendingnews' ),
			'section'     => 'footer_widget_section',
			'choices'     => trendingnews_get_footer_layouts(),
			'priority'    => 40,
		)
	)
);
