<?php
$wp_customize->add_section(
    'pagination_options',
    array(
        'title' => esc_html__( 'Pagination Options', 'trendingnews' ),
        'panel' => 'archive_options_panel',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[select_pagination_style]',
    array(
        'default'           => $trendingnews_default['select_pagination_style'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_pagination_style]',
    array(
        'label'         => esc_html__( 'Select Pagination Style', 'trendingnews' ),
        'section'     => 'pagination_options',
        'type'        => 'select',
        'choices'       => trendingnews_pagination_style_choice(),

    )
);


$wp_customize->add_section(
    'excerpt_options',
    array(
        'title' => esc_html__( 'Excerpt Options', 'trendingnews' ),
        'panel' => 'archive_options_panel',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[number_of_word_in_excerpt]',
    array(
        'default'           => $trendingnews_default['number_of_word_in_excerpt'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[number_of_word_in_excerpt]',
    array(
        'label'         => esc_html__( 'Number Of Excerpt Word', 'trendingnews' ),
        'section'     => 'excerpt_options',
        'type'        => 'number',

    )
);


$wp_customize->add_setting(
    'trendingnews_options[excerpt_posts_title_limit]',
    array(
        'default'           => $trendingnews_default['excerpt_posts_title_limit'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[excerpt_posts_title_limit]',
    array(
        'label'    => __( 'Excerpt Line Limit', 'trendingnews' ),
        'section'  => 'excerpt_options',
        'type'     => 'select',
        'choices'  => trendingnews_line_limit_choices(),
    )
);

$wp_customize->add_setting(
    'trendingnews_options[archive_excerpt_button_text]',
    array(
        'default'           => $trendingnews_default['archive_excerpt_button_text'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[archive_excerpt_button_text]',
    array(
        'label'    => __( 'Excerpt Button Text', 'trendingnews' ),
        'section'  => 'excerpt_options',
        'type'     => 'text',
    )
);