<?php
/**
 * All settings related to footer recommended post.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
	'dual_insights',
	array(
		'title' => esc_html__( 'Dual Insights Section', 'trendingnews' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'trendingnews_options[enable_dual_insights]',
    array(
        'default'           => $trendingnews_default['enable_dual_insights'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_dual_insights]',
    array(
        'label'       => esc_html__( 'Enable Dual Insights', 'trendingnews' ),
        'section'     => 'dual_insights',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
  'trendingnews_options[dual_insights_title]',
  array(
      'default' => $trendingnews_default['dual_insights_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'trendingnews_options[dual_insights_title]',
  array(
      'label' => __('Section Title', 'trendingnews'),
      'section' => 'dual_insights',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_dual_insights_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_dual_insights_1',
        array(
            'label'         => esc_html__( 'Dual Insights Column - 1', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_dual_insights_1',
            'section' => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[main_insights_category]',
    array(
        'default'           => $trendingnews_default['main_insights_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[main_insights_category]',
        array(
            'label'           => __( 'Choose Column - 1 Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[insights_post_1_offset]',
    array(
        'default' => $trendingnews_default['insights_post_1_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[insights_post_1_offset]',
    array(
        'label' => __('Insights Post Offset - 1', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'trendingnews_section_seperator_dual_insights_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_dual_insights_2',
        array(
            'label'         => esc_html__( 'Dual Insights Column - 2', 'trendingnews' ),
            'settings' => 'trendingnews_section_seperator_dual_insights_2',
            'section' => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
  'trendingnews_options[dual_inner_column_title]',
  array(
      'default' => $trendingnews_default['dual_inner_column_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'trendingnews_options[dual_inner_column_title]',
  array(
      'label' => __('Inner Column Title', 'trendingnews'),
      'section' => 'dual_insights',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'trendingnews_options[trending_insights_category]',
    array(
        'default'           => $trendingnews_default['trending_insights_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[trending_insights_category]',
        array(
            'label'           => __( 'Choose Column - 2 Category', 'trendingnews' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'trendingnews' ),
            'section'         => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'trendingnews_options[insights_post_2_offset]',
    array(
        'default' => $trendingnews_default['insights_post_2_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[insights_post_2_offset]',
    array(
        'label' => __('Insights Post Offset - 2', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);


$wp_customize->add_setting(
    'trendingnews_options[enable_insights_author_meta]',
    array(
        'default' => $trendingnews_default['enable_insights_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_insights_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_insights_author_meta]',
    array(
        'default' => $trendingnews_default['select_insights_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[insights_author_meta_title]',
    array(
        'default' => $trendingnews_default['insights_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[insights_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_insights_date_meta]',
    array(
        'default' => $trendingnews_default['enable_insights_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_insights_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_insights_date]',
    array(
        'default' => $trendingnews_default['select_insights_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_insights_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_insights_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_insights_date_format]',
    array(
        'default' => $trendingnews_default['select_insights_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_insights_category_meta]',
    array(
        'default' => $trendingnews_default['enable_insights_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_insights_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_insights_number_of_category]',
    array(
        'default' => $trendingnews_default['select_insights_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[insights_category_label]',
    array(
        'default' => $trendingnews_default['insights_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[insights_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'trendingnews_options[select_insights_category_color]',
    array(
        'default' => $trendingnews_default['select_insights_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_insights_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);