<?php
/**
 * All settings related to footer recommended post.
 *
 * @package TrendingNews
 */
$wp_customize->add_section(
    'article_list_post',
    array(
        'title' => esc_html__('Article List Section', 'trendingnews'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_list_post]',
    array(
        'default' => $trendingnews_default['enable_article_list_post'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_list_post]',
    array(
        'label' => esc_html__('Enable Article List Post', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_title]',
    array(
        'default' => $trendingnews_default['article_list_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_list_title]',
    array(
        'label' => __('Section Title', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_section_seperator_article_list_1',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_list_1',
        array(
            'label' => esc_html__('Article List Column - 1', 'trendingnews'),
            'settings' => 'trendingnews_section_seperator_article_list_1',
            'section' => 'article_list_post',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_category_1]',
    array(
        'default' => $trendingnews_default['article_list_post_category_1'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[article_list_post_category_1]',
        array(
            'label' => __('Choose Column - 1 Category', 'trendingnews'),
            'description' => __('Leave Empty if you don\'t want the posts to be category specific', 'trendingnews'),
            'section' => 'article_list_post',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_1_offset]',
    array(
        'default' => $trendingnews_default['article_list_post_1_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_list_post_1_offset]',
    array(
        'label' => __('Article List Post Offset', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_section_seperator_article_list_3',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_list_3',
        array(
            'label' => esc_html__('Article List Column - 2', 'trendingnews'),
            'settings' => 'trendingnews_section_seperator_article_list_3',
            'section' => 'article_list_post',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_category_3]',
    array(
        'default' => $trendingnews_default['article_list_post_category_3'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new TrendingNews_Dropdown_Taxonomies_Control(
        $wp_customize,
        'trendingnews_options[article_list_post_category_3]',
        array(
            'label' => __('Choose Column - 2 Category', 'trendingnews'),
            'description' => __('Leave Empty if you don\'t want the posts to be category specific', 'trendingnews'),
            'section' => 'article_list_post',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_3_offset]',
    array(
        'default' => $trendingnews_default['article_list_post_3_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_list_post_3_offset]',
    array(
        'label' => __('Article List Post Offset', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_section_seperator_article_list_meta',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);
$wp_customize->add_control(
    new TrendingNews_Seperator_Control(
        $wp_customize,
        'trendingnews_section_seperator_article_list_meta',
        array(
            'label' => esc_html__('Article List Meta Option', 'trendingnews'),
            'settings' => 'trendingnews_section_seperator_article_list_meta',
            'section' => 'article_list_post',
        )
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_list_post_author_meta]',
    array(
        'default' => $trendingnews_default['enable_article_list_post_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_list_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_author_meta]',
    array(
        'default' => $trendingnews_default['select_article_list_post_author_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'select',
        'choices' => trendingnews_author_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_author_meta_title]',
    array(
        'default' => $trendingnews_default['article_list_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_list_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_list_post_date_meta]',
    array(
        'default' => $trendingnews_default['enable_article_list_post_date_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_list_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_date]',
    array(
        'default' => $trendingnews_default['select_article_list_post_date'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'select',
        'choices' => trendingnews_date_meta(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_date_meta_title]',
    array(
        'default' => $trendingnews_default['select_article_list_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_date_format]',
    array(
        'default' => $trendingnews_default['select_article_list_post_date_format'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'select',
        'choices' => trendingnews_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'trendingnews_options[enable_article_list_post_category_meta]',
    array(
        'default' => $trendingnews_default['enable_article_list_post_category_meta'],
        'sanitize_callback' => 'trendingnews_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'trendingnews_options[enable_article_list_post_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_number_of_category]',
    array(
        'default' => $trendingnews_default['select_article_list_post_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_number_of_category]',
    array(
        'label' => __('Number of Category', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[article_list_post_category_label]',
    array(
        'default' => $trendingnews_default['article_list_post_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'trendingnews_options[article_list_post_category_label]',
    array(
        'label' => __('Category Label', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'trendingnews_options[select_article_list_post_category_color]',
    array(
        'default' => $trendingnews_default['select_article_list_post_category_color'],
        'sanitize_callback' => 'trendingnews_sanitize_select',
    )
);
$wp_customize->add_control(
    'trendingnews_options[select_article_list_post_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'trendingnews'),
        'section' => 'article_list_post',
        'type' => 'select',
        'choices' => trendingnews_category_color(),
    )
);